DECLARE SUB DefinisciCharSet ()
DECLARE SUB Char (Table() AS STRING * 1, NumChar AS INTEGER)
DECLARE FUNCTION CalcolaMediaSq! (Mode AS INTEGER)
DECLARE FUNCTION PartitaGiocata! (Index AS INTEGER)
DECLARE FUNCTION ContaPartite! (Mode AS INTEGER)
DECLARE SUB StatNumeri ()
DECLARE SUB DosShell ()
DECLARE FUNCTION CalcolaPresenze (Player AS INTEGER) AS INTEGER
DECLARE FUNCTION CalcolaPresenzeRel (Player AS INTEGER) AS INTEGER
DECLARE SUB ImpostaPercentuali ()
DECLARE SUB StartCount ()
DECLARE FUNCTION CalcolaGoalSubiti! (Plyr AS INTEGER)
DECLARE FUNCTION CalcolaMedia (Player AS INTEGER) AS INTEGER
DECLARE SUB PStampaGoleador (STeam() AS INTEGER)
DECLARE SUB HotKey (in AS STRING)
DECLARE SUB SortPlayer (STeam() AS INTEGER, TypeS AS INTEGER)
DECLARE FUNCTION CalcolaGoalSegnati! (Plyr AS INTEGER)
DECLARE SUB StatGoals ()
DECLARE SUB CalcolaFormTipo ()
DECLARE SUB PStampaStatTeam ()
DECLARE SUB StatTeam ()
DECLARE FUNCTION InSquadra (Player AS INTEGER) AS INTEGER
DECLARE SUB PStampaStatistica ()
DECLARE SUB StatPlayer ()
DECLARE SUB PIntestazione (Fl AS INTEGER)
DECLARE SUB PStampaVoti ()
DECLARE SUB PStampaGiornate ()
DECLARE SUB PStampaFormazione ()
DECLARE SUB PStampaSquadra ()
DECLARE SUB ExitProgram ()
DECLARE SUB SaveT ()
DECLARE SUB SaveFile (NomeFile AS STRING)
DECLARE SUB LoadT ()
DECLARE FUNCTION CalcolaGoal (Punteggio AS STRING) AS STRING
DECLARE SUB MostraListaGiornata (Riga AS INTEGER, DummyValues() AS INTEGER)
DECLARE SUB StampaFormazione ()
DECLARE SUB ImpostaGiornata ()
DECLARE SUB RuoliGiocatori (Modulo AS STRING)
DECLARE SUB DisegnaCampo (X AS INTEGER, Y AS INTEGER, Tipo AS STRING)
DECLARE FUNCTION ZTrim$ (in AS STRING)
DECLARE SUB ImpostaFormazione ()
DECLARE SUB Menu ()
DECLARE SUB GGiocatori ()
DECLARE SUB GCampionato ()
DECLARE SUB StampaGiornata (Index AS INTEGER)
DECLARE SUB StampaNome (SIndex AS INTEGER)
DECLARE SUB Mostra ()
DECLARE SUB LoadFile (NomeFile AS STRING)
DECLARE SUB MostraGiocatori (Riga AS INTEGER)
DECLARE SUB MostraGiornate (Riga AS INTEGER)
DECLARE SUB Mask ()
OPTION EXPLICIT
'$INCLUDE: 'MOUSE.BI'
'$INCLUDE: 'WIN10.BI'
'$INCLUDE: 'FILE.BI'
REM **************************************************************************
REM **********                                                   *************
REM **********        CMPIONT.BAS  B.d. software 1996-98        *************
REM **********                                                   *************
REM **************************************************************************


'CONST FALSE = 0, TRUE = NOT FALSE

CONST CP_PERSE = 1      'Costanti per la procedura ContaPartite
CONST CP_VINTE = 2
CONST CP_PAREGGIATE = 3

CONST CM_PARTITA = 1    'Costanti per la procedura CalcolaMediaSq
CONST CM_INGLESE = 2

COMMON SHARED Campionato() AS Giornata
COMMON SHARED Squadra() AS Giocatore

REDIM SHARED Squadra(0) AS Giocatore
DIM SHARED Campionato(40)  AS Giornata

DIM SHARED DayRow AS INTEGER    'Linea di visualizzazione Giornata
DIM SHARED DaySel AS INTEGER    'Giornata selezionata
DIM SHARED PlyrRow AS INTEGER   'Linea di visualizzazione Giocatore
DIM SHARED PlyrSel AS INTEGER   'Giocatore selezionato

DIM SHARED ActiveWin AS INTEGER 'Finestra attiva in schermo (1=Giocatore, 2=Giornate)

DIM SHARED MenuFormazione(19) AS Pnt   'Posizioni e impostazioni menu formazione
DIM SHARED MenuGiornata(9) AS Pnt      'Posizioni e impostazioni menu impostazione giornata

DIM SHARED Printr AS STRING     'Impostazioni della stampante

DIM SHARED FileName AS STRING   'Nome del file in uso

DIM SHARED Perc AS INTEGER      'Percentuale valutazione importanza presenze/media

DIM SHARED CpuSpeed AS LONG     'Valore proporzionale alla velocit del computer

DIM SHARED MedieConGoal AS INTEGER  'Flag: calcolo medie con goal etc.

CONST DEMO = 0                      'Flag: versione demo/completa

REDIM SHARED AlternativeSet(0) AS STRING * 1'Stringa contenente il set di caratteri alternativo

MedieConGoal = TRUE

ON ERROR RESUME NEXT


DIM Index AS INTEGER


IF DEMO THEN
	COLOR , 1
	CLS
	Win 40, 12, 50, 10, 4, 15, TRUE
	Center 7, "GESTIONE CAMPIONATO 1.1a"
	Center 8, "VERSIONE DIMOSTRATIVA"
	Center 10, "Le giornate gestibili sono le prime quattro"
	Center 12, "Per la versione completa, inviare 10000 a "
	Center 14, "Davide Bucci"
	Center 15, "Via Mompellato 5 10051 Avigliana (TO)"
	Center 16, "Tel 011/9342114 "


	DO: LOOP WHILE INKEY$ = ""
	CLS
END IF

Mask
COLOR 15, 1
LOCATE 3, 4: PRINT "Avvio del programma... Attendere prego."

CpuSpeed = GetCPUspeed()
MouseInit

MouseShow
IF Exists("Files.dat") THEN         'Leggi l'ultimo file caricato o salvato
	DIM Fl AS INTEGER
	DIM Percentuale AS STRING
	DIM Dummy AS STRING
	Fl = FREEFILE

	OPEN "Files.Dat" FOR INPUT AS #Fl
		INPUT #Fl, FileName
		INPUT #Fl, Percentuale

		IF VAL(Percentuale) <= 100 THEN
			Perc = VAL(Percentuale)
		ELSE
			Perc = 0
		END IF

		INPUT #1, Dummy
		MedieConGoal = VAL(Dummy)

	CLOSE #Fl
	IF Exists(FileName) THEN LoadFile FileName
END IF

IF Exists("pLPT2.PRN") THEN Printr = "lpt2:" ELSE Printr = "lpt1:"

DayRow = 1: PlyrRow = 1
MostraGiornate PlyrRow

LOCATE 3, 4: PRINT "                          "
MostraGiocatori DayRow

IF UBOUND(Squadra) THEN PlyrSel = 1

DO
	GCampionato
	GGiocatori
LOOP

SUB CalcolaFormTipo ()

	' Calcolo della formazione ideale.
	' Il principio  semplicemente di prendere i giocatori con medie pi alte.

	DIM Scrn(4000) AS INTEGER
	DIM STeam(UBOUND(Squadra)) AS INTEGER
	DIM Index AS INTEGER

	DIM Attaccanti(UBOUND(Squadra)) AS INTEGER  'Liste giocatori per categoria
	DIM Centrocamp(UBOUND(Squadra)) AS INTEGER
	DIM Difensori(UBOUND(Squadra)) AS INTEGER
	DIM Portieri(UBOUND(Squadra)) AS INTEGER

	DIM Va AS INTEGER   'Puntatori per array di giocatori
	DIM Vc AS INTEGER
	DIM Vd AS INTEGER
	DIM Vp AS INTEGER

	DIM Stranieri AS INTEGER    'Numero di stranieri in formazione
	
	DIM Modulo AS STRING            'Modulo selezionato dall'utente
	DIM Formula AS STRING           'Stringa che contiene i ruoli dei giocatori

	DIM DummyTeam(11)  AS INTEGER   'Composizione della formazione tipo


	Modulo = RTRIM$(ZTrim$(MenuFormazione(1).t))    'Controlla il modulo

	IF Modulo = "" THEN Msg 40, 12, "Impostare il modulo della formazione": EXIT SUB

	ScreenSave Scrn()

	Win 40, 12, 60, 15, 4, 15, TRUE
	Center 12, " Calcolo formazione ideale - Attendere prego "
	
	SortPlayer STeam(), 0

	LOCATE 1
	FOR Index = 1 TO UBOUND(Squadra)        ' "Smistamento" dei giocatori per ruolo
		SELECT CASE UCASE$(Squadra(STeam(Index)).Tipo)
			CASE "A"
				Va = Va + 1
				Attaccanti(Va) = STeam(Index)
				
			CASE "C"
				Vc = Vc + 1
				Centrocamp(Vc) = STeam(Index)

			CASE "D"
				Vd = Vd + 1
				Difensori(Vd) = STeam(Index)

			CASE "P"
				Vp = Vp + 1
				Portieri(Vp) = STeam(Index)

		END SELECT
	
	NEXT

	Formula = SPACE$(30)

	SELECT CASE Modulo
		CASE "4 4 2"
			Formula = "PDDDDCCCCAA"

		CASE "4 3 3"
			Formula = "PDDDDCCCAAA"

		CASE "5 4 1"
			Formula = "PDDDDDCCCCA"

		CASE "5 3 2"
			Formula = "PDDDDDCCCAA"

		CASE "6 3 1"
			Formula = "PDDDDDDCCCA"

		CASE "3 4 3"
			Formula = "PDDDCCCCAAA"

		CASE "3 5 2"
			Formula = "PDDDCCCCCAA"

		CASE ELSE
			ScreenRestore Scrn()
			Msg 40, 12, "Impostare un modulo di formazione standard"
			EXIT SUB
	
	END SELECT

	Va = 0
	Vc = 0
	Vd = 0
	Vp = 0

	ON LOCAL ERROR RESUME NEXT

	FOR Index = 1 TO 11
		SELECT CASE MID$(Formula, Index, 1)
			CASE "P"                'Portieri
ReSelP:
				Vp = Vp + 1
				IF Squadra(Portieri(Vp)).Straniero = "S" THEN
					Stranieri = Stranieri + 1
					IF Stranieri > 3 THEN GOTO ReSelP       'Lo so che non  bello...
				END IF
				DummyTeam(Index) = Portieri(Vp)

			CASE "D"                'Difensori
ReSelD:
				Vd = Vd + 1
				IF Squadra(Difensori(Vd)).Straniero = "S" THEN
					Stranieri = Stranieri + 1
					IF Stranieri > 3 THEN GOTO ReSelD
				END IF

				DummyTeam(Index) = Difensori(Vd)

			CASE "C"                'Centrocampisti
ReSelC:
				Vc = Vc + 1
				IF Squadra(Centrocamp(Vc)).Straniero = "S" THEN
					Stranieri = Stranieri + 1
					IF Stranieri > 3 THEN GOTO ReSelC
				END IF

				DummyTeam(Index) = Centrocamp(Vc)

			CASE "A"                'Attaccanti
ReSelA:
				Va = Va + 1
				IF Squadra(Attaccanti(Va)).Straniero = "S" THEN
					Stranieri = Stranieri + 1
					IF Stranieri > 3 THEN GOTO ReSelA
				END IF

				DummyTeam(Index) = Attaccanti(Va)
			  

		END SELECT
	NEXT

	IF ERR THEN
		Msg 40, 12, " Giocatori non sufficenti per completare la formazione "
		ScreenRestore Scrn()
		EXIT SUB
	END IF

	Center 12, "                                             "
	Center 4, " Formazione ideale "

	LOCATE 6, 14: PRINT USING "Modulo utilizzato: \     \          Giornata n: ##"; Modulo; DaySel
	PRINT

	FOR Index = 1 TO 11

		LOCATE , 20
		IF Squadra(DummyTeam(Index)).Straniero = "S" THEN COLOR 14, 4
		PRINT Squadra(DummyTeam(Index)).Nome,   ' Nome del giocatore
		COLOR 15, 4
		PRINT MID$(Formula, Index, 1);          ' Ruolo del giocatore
		PRINT USING "      ###.#"; CalcolaMedia(DummyTeam(Index)) / 100; ' Media per giornata del giocatore
		PRINT USING "    ##"; CalcolaPresenze(DummyTeam(Index))        ' Numero presenze in campionato

	NEXT

	LOCATE 20, 20
	COLOR 14, 4: PRINT "[CR]";
	COLOR 15, 4: PRINT " Accetta dati     ";
	COLOR 14, 4: PRINT "[ESC]";
	COLOR 15, 4: PRINT " Annulla"



	DIM in AS STRING


	DO
		DO
			in = INKEY$

		LOOP WHILE in = ""

		SELECT CASE in

			CASE CHR$(13)   'Invio
				FOR Index = 1 TO 11
					MenuFormazione(Index + 1).t = Squadra(DummyTeam(Index)).Nome
				NEXT
				EXIT DO

			CASE CHR$(0) + CHR$(59)'[F1]
				Help 40, 12, 60, 15, "fanta.hlp", "FORMAZIONE_IDEALE", 4, 15
			


			CASE CHR$(27)   'ESC
				EXIT DO

		END SELECT

	LOOP

	ScreenRestore Scrn()

END SUB

FUNCTION CalcolaGoal (Punteggio AS STRING) AS STRING
'Calcola i goal segnati con un determinato punteggio

DIM Scores AS INTEGER
DIM Number AS STRING

Scores = VAL(Punteggio)

IF Scores < 660 THEN Number = "0"
IF Scores >= 660 THEN Number = "1"
IF Scores >= 720 THEN Number = "2"
IF Scores >= 780 THEN Number = "3"
IF Scores >= 840 THEN Number = "4"
IF Scores >= 900 THEN Number = "5"
IF Scores >= 960 THEN Number = "6"

CalcolaGoal = Number


END FUNCTION

FUNCTION CalcolaGoalSegnati (Plyr AS INTEGER)

' Funzione che restituisce il numero di goal segnati in
' tutto il campionato.

	DIM Index AS INTEGER
	DIM Totale AS INTEGER
	DIM Voto AS INTEGER
	

	FOR Index = 1 TO 30

		Voto = ASC(MID$(Squadra(Plyr).Risultati, Index * 3 - 1, 1)) AND 127

		Totale = Totale + (Voto \ 30)
		
	NEXT

	CalcolaGoalSegnati = Totale
	
END FUNCTION

FUNCTION CalcolaGoalSubiti (Plyr AS INTEGER)

' Funzione che restituisce il numero di goal segnati in
' tutto il campionato.

	DIM Index AS INTEGER
	DIM Totale AS INTEGER
	DIM Voto AS INTEGER


	FOR Index = 1 TO 30

		Voto = ASC(MID$(Squadra(Plyr).Risultati, Index * 3, 1)) AND 127

		Totale = Totale + (Voto \ 10)

	NEXT

	CalcolaGoalSubiti = Totale



END FUNCTION

FUNCTION CalcolaMedia (Player AS INTEGER) AS INTEGER

	' Calcolo media aritmetica (moltiplicata per 100) per il giocatore indicato

	DIM Index AS INTEGER
	DIM Totale AS INTEGER
	DIM Voto AS INTEGER
	DIM presenze AS INTEGER


	FOR Index = 1 TO 30'UBOUND(Squadra)

		Voto = ASC(MID$(Squadra(Player).Risultati, Index * 3 - 2, 1)) AND 127
		IF MedieConGoal THEN
			Voto = Voto + (ASC(MID$(Squadra(Player).Risultati, Index * 3 - 1, 1)) AND 127)
			Voto = Voto - (ASC(MID$(Squadra(Player).Risultati, Index * 3, 1)) AND 127)
		END IF

		IF Voto THEN
			presenze = presenze + 1
			Totale = Totale + Voto
		END IF
	NEXT

	IF presenze > 0 THEN
		CalcolaMedia = CINT((100 * CLNG(Totale)) / presenze)
	END IF

END FUNCTION

FUNCTION CalcolaMediaSq (Mode AS INTEGER) AS SINGLE

	DIM Index AS INTEGER
	DIM Media AS SINGLE

	DIM P_Avv AS INTEGER
	DIM P_Squ AS INTEGER

	DIM PartiteGiocate AS INTEGER

	
	SELECT CASE Mode
		CASE CM_INGLESE

			FOR Index = 0 TO UBOUND(Campionato)
				IF PartitaGiocata(Index) THEN
					P_Avv = VAL(Campionato(Index).Goal_A)
					P_Squ = VAL(Campionato(Index).Goal_S)

					IF P_Avv = P_Squ THEN
						
					ELSEIF P_Avv < P_Squ THEN
						Media = Media + 1
					ELSE
						Media = Media - 1
					END IF

					IF UCASE$(Campionato(Index).InCasa) = "C" THEN
						Media = Media - 1
					END IF
				END IF
			NEXT

		CASE CM_PARTITA
			FOR Index = 0 TO UBOUND(Campionato)
				IF PartitaGiocata(Index) THEN
					PartiteGiocate = PartiteGiocate + 1
					Media = Media + VAL(Campionato(Index).Punteggio_S)
				END IF
			NEXT
			Media = Media / PartiteGiocate

	END SELECT

	CalcolaMediaSq = Media
	
END FUNCTION

FUNCTION CalcolaPresenze (Player AS INTEGER) AS INTEGER

' Calcola il numero di presenze in campionato


	DIM Index AS INTEGER
	DIM Voto AS INTEGER
	DIM presenze AS INTEGER


	FOR Index = 1 TO 30

		Voto = ASC(MID$(Squadra(Player).Risultati, Index * 3 - 2, 1)) AND 127

		IF Voto THEN
			presenze = presenze + 1
		
		END IF
	NEXT


	CalcolaPresenze = presenze
'    PRINT presenze


END FUNCTION

FUNCTION ContaPartite (Mode AS INTEGER)

	' Calcolo del numero delle partite vinte, perse o pareggiate.

	DIM Index AS INTEGER
	DIM Result AS INTEGER
	DIM P_Avv AS INTEGER
	DIM P_Squ AS INTEGER

	FOR Index = 0 TO UBOUND(Campionato)
		IF PartitaGiocata(Index) THEN

			P_Avv = VAL(Campionato(Index).Goal_A)
			P_Squ = VAL(Campionato(Index).Goal_S)

			SELECT CASE Mode
				CASE CP_PERSE
					IF P_Avv > P_Squ THEN Result = Result + 1

				CASE CP_VINTE
					IF P_Avv < P_Squ THEN Result = Result + 1

				CASE CP_PAREGGIATE
					IF P_Avv = P_Squ THEN Result = Result + 1
			END SELECT
		END IF
	NEXT

	ContaPartite = Result

END FUNCTION

SUB DefinisciCharSet ()

DIM Fl AS INTEGER
DIM Index AS INTEGER

IF Exists("Charset.dat") THEN
	Fl = FREEFILE
	OPEN "CharSet.dat" FOR BINARY AS #Fl
		REDIM AlternativeSet(LOF(Fl)) AS STRING * 1
		FOR Index = 1 TO LOF(Fl)
			GET #Fl, , AlternativeSet(Index)
		NEXT
	CLOSE #Fl
ELSE
	Msg 40, 12, "Impossibile ridefinire il set di caratteri"
END IF




Char AlternativeSet(), UBOUND(AlternativeSet) / 16
END SUB

SUB DisegnaCampo (X AS INTEGER, Y AS INTEGER, Tipo AS STRING)
'Disegnino con caratteri ASCII della met campo

DIM Attc AS STRING
DIM Cent AS STRING
DIM Difn AS STRING


LOCATE Y

LOCATE , X: PRINT "Ĵ"
LOCATE , X: PRINT "             "
LOCATE , X: PRINT "             "
LOCATE , X: PRINT "             "
LOCATE , X: PRINT "    Ŀ    "
LOCATE , X: PRINT ""

SELECT CASE Tipo
	CASE "4 4 2"
		Attc = " X       X"
		Cent = "X  X   X  X"
		Difn = "X  X   X  X"

	CASE "4 3 3"
		Attc = " X   X  X"
		Cent = " X   X  X"
		Difn = "X  X   X  X"

	CASE "5 4 1"
		Attc = "     X "
		Cent = "X  X   X  X"
		Difn = "X X  X  X X"

	CASE "5 3 2"
		Attc = "  X     X"
		Cent = "  X  X  X"
		Difn = "X X  X  X X"

	CASE "6 3 1"
		Attc = "     X"
		Cent = "  X  X  X"
		Difn = "X X X X X X"

	CASE "3 4 3"
		Attc = "  X  X  X"
		Cent = "X  X   X  X"
		Difn = "  X  X  X"

	CASE "3 5 2"
		Attc = " X       X"
		Cent = "X X  X  X X"
		Difn = "  X  X  X  "

	CASE ""
	
END SELECT
LOCATE Y + 1, X + 2: PRINT Attc
LOCATE , X + 2: PRINT Cent
LOCATE , X + 2: PRINT Difn

END SUB

SUB DosShell ()

DIM Scrn(4000) AS INTEGER

MouseHide
ScreenSave Scrn()
COLOR 7, 0
CLS
PRINT "     Digitare EXIT per tornare a Gestione Fantacalcio"
SHELL
IF CpuSpeed < 300 THEN
	ScreenRestore Scrn()
ELSE
	Dissolvi Scrn()
END IF
MouseShow


END SUB

SUB ExitProgram ()

	IF SceltaSiNo("Si desidera uscire dall'ambiente di gestione campionato?", 40, 12) = 1 THEN
		COLOR 7, 0
		CLS

		DIM Fl AS INTEGER
		Fl = FREEFILE

		OPEN "Files.Dat" FOR OUTPUT AS #Fl
			PRINT #Fl, FileName
			PRINT #Fl, STR$(Perc)
			PRINT #Fl, MedieConGoal
		CLOSE #Fl
		MouseHide

		END
	END IF
END SUB

SUB GCampionato ()

	' Routine principale di visualizzazione e scroll giornate di campionato

	DIM OldSel AS INTEGER
	DIM in AS STRING

	DIM X AS INTEGER, oX AS INTEGER        ' Variabili usate per il mouse
	DIM Y AS INTEGER, oY AS INTEGER
	DIM Lb AS INTEGER, oLb AS INTEGER
	DIM Rb AS INTEGER, oRb AS INTEGER

	DIM Clicked AS INTEGER                 ' Flag per doppio click


	ActiveWin = 2   'Impostazione della finestra attiva

	IF DayRow = 0 THEN DayRow = 1
	IF DaySel = 0 THEN DaySel = 1
	COLOR 15, 1

	LOCATE DaySel - DayRow + 12, 2: PRINT " "   'Elimina vecchio indicatore di selezione
	
	IF UBOUND(Campionato) = 0 THEN EXIT SUB
	MostraGiornate DayRow
	MousePoll Y, X, Lb, Rb
	DO
		IF DaySel <> OldSel THEN      'Selezione cambiata
			IF OldSel THEN LineEvidences 2, OldSel - DayRow + 11, 76
			IF DaySel THEN LineEvidences 2, DaySel - DayRow + 11, 76
			OldSel = DaySel
		END IF

		VscrollBar 80, 15, 7, 1, 7, DaySel / UBOUND(Campionato) * 100

		DO
			in = INKEY$
			oX = X: oY = Y: oLb = Lb: oRb = Rb
			MousePoll Y, X, Lb, Rb
			IF (oX <> X) OR (oY <> Y) THEN  ' Se il mouse si  spostato
				in = CHR$(0)
			END IF
			IF oLb = TRUE AND Lb = FALSE THEN
				Clicked = TRUE
				IF X = 80 AND (Y >= 12 AND Y <= 19) THEN      'Click sulla barra di scorrimento
					IF Y = 12 THEN                      'Key Up
						in = CHR$(0) + CHR$(72)
					ELSEIF Y = 19 THEN                 'Key Down
						in = CHR$(0) + CHR$(80)
					ELSEIF Y < (DaySel / UBOUND(Campionato) * 10) + 12 THEN    'Page Up
						in = CHR$(0) + CHR$(73)
					ELSEIF Y > (DaySel / UBOUND(Campionato) * 10) + 12 THEN    'Page Down
						in = CHR$(0) + CHR$(81)
					END IF
				ELSE
					IF Y < 20 THEN DaySel = Y + DayRow - 12
					in = CHR$(0)
				END IF
			END IF

		LOOP WHILE in = ""

		SELECT CASE in
			CASE CHR$(0) + CHR$(72) 'Up
				DaySel = DaySel - 1

			CASE CHR$(0) + CHR$(80) 'Down
				DaySel = DaySel + 1

			CASE CHR$(0) + CHR$(73) 'Page Up
				IF DaySel THEN LineEvidences 2, DaySel - DayRow + 11, 76
				DayRow = DayRow - 8
				IF DayRow < 1 THEN DayRow = 1
				MostraGiornate DayRow
				DaySel = DayRow
				OldSel = 0

			CASE CHR$(0) + CHR$(81) 'Page Down
				IF DaySel THEN LineEvidences 2, DaySel - DayRow + 11, 76
				DayRow = DayRow + 8
				IF DayRow > UBOUND(Campionato) - 7 THEN DayRow = UBOUND(Campionato) - 7
				MostraGiornate DayRow
				DaySel = DayRow
				OldSel = 0


			CASE CHR$(27)           '[ESC]
				IF DaySel THEN
					LineEvidences 2, DaySel - DayRow + 11, 76
					COLOR 15, 1
					LOCATE DaySel - DayRow + 12, 2: PRINT ""
					Menu
					COLOR 15, 1
					LOCATE DaySel - DayRow + 12, 2: PRINT " "
					OldSel = 0
				END IF

			CASE CHR$(13)           'Invio
				IF DaySel THEN
					LineEvidences 2, DaySel - DayRow + 11, 76
					COLOR 15, 1
					LOCATE DaySel - DayRow + 12, 2: PRINT ""
					Menu
					COLOR 15, 1
					LOCATE DaySel - DayRow + 12, 2: PRINT " "
					OldSel = 0
				END IF

				

			CASE CHR$(0) + CHR$(64) '[F6]
				IF DaySel THEN
					LineEvidences 2, DaySel - DayRow + 11, 76
					LOCATE DaySel - DayRow + 12, 2: PRINT ""
					EXIT SUB
				END IF
				
			CASE CHR$(9)            '[TAB]
				IF DaySel THEN
					LineEvidences 2, DaySel - DayRow + 11, 76
					LOCATE DaySel - DayRow + 12, 2: PRINT ""
					EXIT SUB
				END IF
				  
			CASE CHR$(0) + CHR$(59)'[F1]
				Help 40, 12, 60, 15, "fanta.hlp", "GESTIONE_CAMPIONATO", 4, 15
				COLOR 15, 1

			CASE CHR$(0) + CHR$(134)'[F12]
				PStampaGiornate

			CASE ELSE
				HotKey in
				COLOR 15, 1
				
		END SELECT

		IF UBOUND(Campionato) AND DaySel < 1 THEN DaySel = 1
		
		IF DEMO THEN                    'Limita la selezione alle prime 4 giornate se versione demo
			IF DaySel > 4 THEN DaySel = 4
		ELSE
			IF DaySel > UBOUND(Campionato) THEN DaySel = UBOUND(Campionato)
		END IF


		IF DaySel < DayRow AND DaySel THEN    'Scroll verso l'alto
			IF OldSel THEN LineEvidences 2, OldSel - DayRow + 11, 76
			DayRow = DayRow - 1
			ScrollWindow 1, 1, 11, 78, 18, 16 + 15
			LOCATE 12
			StampaGiornata DayRow
			IF DaySel THEN LineEvidences 2, DaySel - DayRow + 11, 76
			OldSel = DaySel
		END IF

		IF DaySel > DayRow + 7 THEN     'Scroll verso il basso
			IF OldSel THEN LineEvidences 2, OldSel - DayRow + 11, 76
			DayRow = DayRow + 1
			ScrollWindow -1, 1, 11, 78, 18, 16 + 15
			LOCATE 19
			StampaGiornata DayRow + 7
			IF DaySel THEN LineEvidences 2, DaySel - DayRow + 11, 76
			OldSel = DaySel
		END IF

		IF ((oY <> Y) OR (oX <> X)) AND Y > 20 THEN         ' Se il cursore non si trova sulla finestra, esci dalla subroutine
			LineEvidences 2, DaySel - DayRow + 11, 76
			LOCATE DaySel - DayRow + 12, 2: PRINT ""
			Menu
			COLOR 15, 1
			LOCATE DaySel - DayRow + 12, 2: PRINT " "
			OldSel = 0
		END IF

		IF ((oY <> Y) OR (oX <> X)) AND Y < 11 THEN         ' Se il cursore non si trova sulla finestra, esci dalla subroutine
			LineEvidences 2, DaySel - DayRow + 11, 76
			LOCATE DaySel - DayRow + 12, 2: PRINT ""
			EXIT SUB
		END IF

	LOOP


END SUB

SUB GGiocatori ()

	' Routine principale di visualizzazione e scroll dei giocatori in squadra.

	DIM OldSel AS INTEGER
	DIM in AS STRING

	DIM X AS INTEGER, oX AS INTEGER        ' Variabili usate per il mouse
	DIM Y AS INTEGER, oY AS INTEGER
	DIM Lb AS INTEGER, oLb AS INTEGER
	DIM Rb AS INTEGER, oRb AS INTEGER


	ActiveWin = 1  'Impostazione della finestra attiva

	IF PlyrRow = 0 THEN PlyrRow = 1
	IF PlyrSel = 0 THEN PlyrSel = 1
	IF UBOUND(Squadra) = 0 THEN EXIT SUB
	COLOR 15, 1
	LOCATE PlyrSel - PlyrRow + 2, 2: PRINT " "  'Elimina vecchio indicatore di selezione
	MostraGiocatori PlyrRow
	MousePoll Y, X, Lb, Rb
	DO
		IF PlyrSel <> OldSel THEN      'Selezione cambiata
			IF OldSel THEN LineEvidences 2, OldSel - PlyrRow + 1, 76
			IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 76
			OldSel = PlyrSel
		END IF

		VscrollBar 80, 6, 8, 1, 7, PlyrSel / UBOUND(Squadra) * 100

		DO
			in = INKEY$
			oX = X: oY = Y: oLb = Lb: oRb = Rb
			MousePoll Y, X, Lb, Rb
			IF (oX <> X) OR (oY <> Y) THEN  ' Se il mouse si  spostato
				in = CHR$(0)
			END IF
			IF oLb = TRUE AND Lb = FALSE THEN
				IF X = 80 AND (Y >= 2 AND Y <= 10) THEN      'Click sulla barra di scorrimento
					IF Y = 2 THEN                      'Key Up
						in = CHR$(0) + CHR$(72)
					ELSEIF Y = 10 THEN                 'Key Down
						in = CHR$(0) + CHR$(80)
					ELSEIF Y < (PlyrSel / UBOUND(Squadra) * 10) + 2 THEN    'Page Up
						in = CHR$(0) + CHR$(73)
					ELSEIF Y > (PlyrSel / UBOUND(Squadra) * 10) + 2 THEN    'Page Down
						in = CHR$(0) + CHR$(81)
						
					END IF
				ELSE
					PlyrSel = Y + PlyrRow - 2
					in = CHR$(0)
				END IF
			END IF

		LOOP WHILE in = ""
		IF ((oY <> Y) OR (oX <> X)) AND Y > 11 THEN         ' Se il cursore non si trova sulla finestra, esci dalla subroutine
			LineEvidences 2, PlyrSel - PlyrRow + 1, 76
			LOCATE PlyrSel - PlyrRow + 2, 2: PRINT ""
			EXIT DO
		END IF
			
		SELECT CASE in
			CASE CHR$(0) + CHR$(72) 'Up
				PlyrSel = PlyrSel - 1
				
			CASE CHR$(0) + CHR$(80) 'Down
				PlyrSel = PlyrSel + 1

			CASE CHR$(0) + CHR$(73) 'Page Up
				IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 76
				PlyrRow = PlyrRow - 9
				IF PlyrRow < 1 THEN PlyrRow = 1
				MostraGiocatori PlyrRow
				PlyrSel = PlyrRow
				OldSel = 0

			CASE CHR$(0) + CHR$(81) 'Page Down
				IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 76
				PlyrRow = PlyrRow + 9
				IF PlyrRow > UBOUND(Squadra) - 8 THEN PlyrRow = UBOUND(Squadra) - 8
				MostraGiocatori PlyrRow
				PlyrSel = PlyrRow
				OldSel = 0

			CASE CHR$(27) '[ESC]
				IF PlyrSel THEN
					COLOR 15, 1
					LineEvidences 2, PlyrSel - PlyrRow + 1, 76
					LOCATE PlyrSel - PlyrRow + 2, 2: PRINT ""
					Menu
					COLOR 15, 1
					IF PlyrSel THEN LOCATE PlyrSel - PlyrRow + 2, 2: PRINT " "
					OldSel = 0
				END IF

			CASE CHR$(13) 'Invio
				IF PlyrSel THEN
					COLOR 15, 1
					LineEvidences 2, PlyrSel - PlyrRow + 1, 76
					LOCATE PlyrSel - PlyrRow + 2, 2: PRINT ""
					Menu
					COLOR 15, 1
					LOCATE PlyrSel - PlyrRow + 2, 2: PRINT " "
					OldSel = 0
				END IF


			CASE CHR$(0) + CHR$(59)'[F1]
				Help 40, 12, 60, 15, "fanta.hlp", "GESTIONE_CAMPIONATO", 4, 15
				COLOR 15, 1

			CASE CHR$(0) + CHR$(64) 'F6
				IF PlyrSel THEN
					LineEvidences 2, PlyrSel - PlyrRow + 1, 76
					LOCATE PlyrSel - PlyrRow + 2, 2: PRINT ""
					EXIT SUB
				END IF

			CASE CHR$(9)            '[TAB]
				IF PlyrSel THEN
					LineEvidences 2, PlyrSel - PlyrRow + 1, 76
					LOCATE PlyrSel - PlyrRow + 2, 2: PRINT ""
					EXIT SUB
				END IF
			
			CASE CHR$(0) + CHR$(134)'[F12]
				PStampaSquadra

			CASE ELSE
				HotKey in
				COLOR 15, 1
				
		END SELECT

		IF UBOUND(Squadra) AND PlyrSel < 1 THEN PlyrSel = 1
		IF PlyrSel > UBOUND(Squadra) THEN PlyrSel = UBOUND(Squadra)

		IF PlyrSel < PlyrRow AND PlyrSel THEN    'Scroll verso l'alto
			IF OldSel THEN LineEvidences 2, OldSel - PlyrRow + 1, 76
			PlyrRow = PlyrRow - 1
			ScrollWindow 1, 1, 1, 78, 9, 16 + 15
			LOCATE 2
			StampaNome PlyrRow
			IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 76
			OldSel = PlyrSel
		END IF

		IF PlyrSel > PlyrRow + 8 THEN     'Scroll verso il basso
			IF OldSel THEN LineEvidences 2, OldSel - PlyrRow + 1, 76
			PlyrRow = PlyrRow + 1
			ScrollWindow -1, 1, 1, 78, 9, 16 + 15
			LOCATE 10
			StampaNome PlyrRow + 8
			IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 76
			OldSel = PlyrSel
		END IF

	LOOP



END SUB

SUB HotKey (in AS STRING)
'Esegui gli hotkey

SELECT CASE in

	CASE CHR$(0) + CHR$(24) 'Alt O
		StatGoals

	CASE CHR$(0) + CHR$(34) 'Alt G
		IF ActiveWin = 1 THEN
			LineEvidences 2, PlyrSel - PlyrRow + 1, 76
		ELSE
			LineEvidences 2, DaySel - DayRow + 11, 76
		END IF

		ImpostaGiornata
		MostraGiornate DayRow
		MostraGiocatori PlyrRow

		IF ActiveWin = 1 THEN
			LineEvidences 2, PlyrSel - PlyrRow + 1, 76
		ELSE
			LineEvidences 2, DaySel - DayRow + 11, 76
		END IF
		
	CASE CHR$(0) + CHR$(33) 'Alt F
		ImpostaFormazione

	CASE CHR$(0) + CHR$(16) 'Alt Q
		StatTeam

	CASE CHR$(0) + CHR$(23) 'Alt I
		StatPlayer

	CASE CHR$(0) + CHR$(35) 'Alt H
		DosShell
	
	CASE CHR$(0) + CHR$(46) 'Alt C
		LoadT
		
	CASE CHR$(0) + CHR$(31) 'Alt S
		SaveT

	CASE CHR$(0) + CHR$(18) 'Alt E
		ExitProgram

	CASE CHR$(0) + CHR$(20) 'Alt T
		StatNumeri

	CASE CHR$(0) + CHR$(47) 'Alt V
		MedieConGoal = NOT (MedieConGoal)
		MostraGiocatori PlyrRow

END SELECT

END SUB

SUB ImpostaFormazione ()

' Finestra per l'introduzione di una formazione per la giornata di campionato

DIM Scrn(4000) AS INTEGER   'Contenuto dello schermo
DIM Index AS INTEGER        'Variabile indice
DIM S AS INTEGER
DIM ActualContent AS STRING


ScreenSave Scrn()

Win 40, 12, 60, 15, 3, 15, 1
Center 4, " Imposta formazione "
LOCATE 5, 14: PRINT "Formazione tipo: ";

MenuFormazione(1).X = POS(1)
MenuFormazione(1).Y = CSRLIN
MenuFormazione(1).C = 15
MenuFormazione(1).t = Campionato(DaySel).TipoFormazione
MenuFormazione(1).D = LEN(Campionato(DaySel).TipoFormazione)

COLOR 15, 0: PRINT Campionato(DaySel).TipoFormazione

COLOR 15, 3
LOCATE 8


FOR Index = 1 TO 11
	COLOR 15, 0
	LOCATE , 38: PRINT "  ";

	MenuFormazione(Index + 1).X = POS(1) + 1
	MenuFormazione(Index + 1).Y = CSRLIN
	MenuFormazione(Index + 1).C = 15
	MenuFormazione(Index + 1).t = Campionato(DaySel).Formazione(Index)
	MenuFormazione(Index + 1).D = LEN(Campionato(DaySel).Formazione(Index))
	
	LOCATE , 41: PRINT SPACE$(LEN(Campionato(DaySel).Formazione(Index)));
	COLOR 15, 3: PRINT " "

NEXT

DisegnaCampo 18, 7, Campionato(DaySel).TipoFormazione
RuoliGiocatori Campionato(DaySel).TipoFormazione

LOCATE 13

FOR Index = 12 TO 18
	COLOR 15, 0
	LOCATE , 13: PRINT "  ";

	MenuFormazione(Index + 1).X = POS(1) + 1
	MenuFormazione(Index + 1).Y = CSRLIN
	MenuFormazione(Index + 1).C = 15
	MenuFormazione(Index + 1).t = Campionato(DaySel).Formazione(Index)
	MenuFormazione(Index + 1).D = LEN(Campionato(DaySel).Formazione(Index))

	LOCATE , 16: PRINT Campionato(DaySel).Formazione(Index)

NEXT
COLOR 15, 3
LOCATE 6, 50: PRINT "Giornata: "; DaySel

COLOR 14, 3
LOCATE 20, 11: PRINT "[CR]";
COLOR 15, 3
PRINT " OK  ";
COLOR 14, 3: PRINT "[ESC]";
COLOR 15, 3: PRINT " Annulla ";
COLOR 14, 3: PRINT "[F12]";
COLOR 15, 3: PRINT " Stampa ";
COLOR 14, 3: PRINT "[F10]";
COLOR 15, 3: PRINT " Optimum ";
COLOR 14, 3: PRINT "[F11]";
COLOR 15, 3: PRINT " % ";


Mostra_Giocatori:
FOR Index = 1 TO 18
	COLOR 15, 0
	LOCATE MenuFormazione(Index + 1).Y, MenuFormazione(Index + 1).X
	PRINT SPACE$(20)
	LOCATE MenuFormazione(Index + 1).Y, MenuFormazione(Index + 1).X
	ActualContent = RTRIM$(ZTrim$(MenuFormazione(Index + 1).t))
	PRINT ActualContent
	ActualContent = UCASE$(ActualContent)
	FOR S = 1 TO UBOUND(Squadra)            'Ricerca del giocatore
		LOCATE MenuFormazione(Index + 1).Y, MenuFormazione(Index + 1).X - 3
		
		IF ActualContent = ZTrim$(RTRIM$(UCASE$(Squadra(S).Nome))) THEN
			PRINT Squadra(S).Numero
			EXIT FOR
		ELSE
			PRINT "  "
		END IF
	NEXT
NEXT


DIM in AS STRING
DIM Selected AS INTEGER
DIM OldSelect AS INTEGER

OldSelect = 1


DO
	IF Selected < 1 THEN Selected = 1
	IF Selected > UBOUND(MenuFormazione) THEN Selected = UBOUND(MenuFormazione)

	IF OldSelect <> Selected THEN
		COLOR 15, 0
		LOCATE MenuFormazione(OldSelect).Y, MenuFormazione(OldSelect).X
		PRINT LEFT$(MenuFormazione(OldSelect).t, MenuFormazione(OldSelect).D);
	END IF

	OldSelect = Selected

	COLOR 15, 7
	ActualContent = ZTrim$(MenuFormazione(Selected).t)
	LOCATE MenuFormazione(Selected).Y, MenuFormazione(Selected).X
	in = MaskedInput(TRUE, MenuFormazione(Selected).D, ActualContent, TRUE)

	LOCATE MenuFormazione(Selected).Y, MenuFormazione(Selected).X
	MenuFormazione(Selected).t = ActualContent
	IF Selected = 1 THEN
		COLOR 15, 3
		DisegnaCampo 18, 7, ActualContent
		RuoliGiocatori ActualContent
	END IF


	IF Selected > 1 THEN

		COLOR 15, 0
		FOR Index = 1 TO UBOUND(Squadra)            'Ricerca del giocatore
			LOCATE MenuFormazione(Selected).Y, MenuFormazione(Selected).X - 3
			IF UCASE$(ActualContent) = ZTrim$(RTRIM$((UCASE$(Squadra(Index).Nome)))) THEN
				PRINT Squadra(Index).Numero
				EXIT FOR
			ELSE

				PRINT "  "
			END IF
		NEXT
	END IF
	
	SELECT CASE in
		CASE CHR$(9)            '[Tab]
			Selected = Selected + 1

		CASE CHR$(0) + CHR$(15) '[SHIFT]+[Tab]
			Selected = Selected - 1

		CASE CHR$(0) + CHR$(134)'F12
			Campionato(DaySel).TipoFormazione = MenuFormazione(1).t     'Salva dati in memoria
			FOR Index = 1 TO 16
				Campionato(DaySel).Formazione(Index) = MenuFormazione(Index + 1).t
			NEXT
			PStampaFormazione

		CASE CHR$(0) + CHR$(68) 'F10
			CalcolaFormTipo

			GOTO Mostra_Giocatori   'Rimostra daccapo tutti i giocatori   AURRRRRGGGG!!!!!!!!  il GOTO!!!!!!!

		CASE CHR$(0) + CHR$(133) 'F11
			ImpostaPercentuali

				  
		CASE CHR$(13)
			EXIT DO
		
		CASE CHR$(27)
			ScreenRestore Scrn()
			EXIT SUB

		CASE CHR$(0) + CHR$(59)'[F1]
			Help 40, 12, 60, 15, "fanta.hlp", "IMPOSTA_FORMAZIONE", 4, 15


	END SELECT

LOOP

ScreenRestore Scrn()

Campionato(DaySel).TipoFormazione = MenuFormazione(1).t
FOR Index = 1 TO 18
	   Campionato(DaySel).Formazione(Index) = MenuFormazione(Index + 1).t
NEXT

END SUB

SUB ImpostaGiornata ()
	DIM Scrn(4000) AS INTEGER
	ScreenSave Scrn()

	DIM Index AS INTEGER            'Variabile indice.
	DIM Riga AS INTEGER             'Numero del primo giocatore visualizzato in lista.
	DIM in AS STRING                'Variabile contenente il codice ricevuto da MaskedInput.
	DIM Selected AS INTEGER         'Numero del campo di immissione selezionato.
	DIM ActualContent AS STRING     'Contenuto del campo di immissione selezionato.
	DIM OldSel AS INTEGER           'Vecchia selezione del giocatore.
	DIM PlayerSel AS INTEGER        'Giocatore in lista selezionato.

	DIM X AS INTEGER, oX AS INTEGER        ' Variabili usate per il mouse
	DIM Y AS INTEGER, oY AS INTEGER
	DIM Lb AS INTEGER, oLb AS INTEGER
	DIM Rb AS INTEGER, oRb AS INTEGER


	DIM DummyValues(3, UBOUND(Squadra)) AS INTEGER  'Punteggi per ciascun giocatore.

	Win 40, 13, 50, 13, 3, 15, TRUE
	Center 6, " Impostazione Giornata "
	LOCATE 8, 24: PRINT "Giornata:"; DaySel

	LOCATE 9, 22: PRINT "Avversario: ";
	MenuGiornata(1).Y = CSRLIN
	MenuGiornata(1).X = POS(1)
	MenuGiornata(1).D = 19
	MenuGiornata(1).C = 15
	MenuGiornata(1).t = Campionato(DaySel).Avversario

	LOCATE 9, 60
	MenuGiornata(2).Y = CSRLIN
	MenuGiornata(2).X = POS(1)
	MenuGiornata(2).D = 1
	MenuGiornata(2).C = 15
	MenuGiornata(2).t = Campionato(DaySel).InCasa
	COLOR 15, 0: PRINT Campionato(DaySel).InCasa

	LOCATE , 20
	COLOR 15, 3: PRINT "Punti subiti: ";
	MenuGiornata(3).Y = CSRLIN
	MenuGiornata(3).X = POS(1)
	MenuGiornata(3).D = 3
	MenuGiornata(3).C = 15
	MenuGiornata(3).t = Campionato(DaySel).Punteggio_A

	COLOR 15, 0: PRINT Campionato(DaySel).Punteggio_A

	LOCATE , 19
	COLOR 15, 3: PRINT "Punti segnati: ";
	MenuGiornata(4).Y = CSRLIN
	MenuGiornata(4).X = POS(1)
	MenuGiornata(4).D = 3
	MenuGiornata(4).C = 15
	MenuGiornata(4).t = Campionato(DaySel).Punteggio_S

	COLOR 15, 0: PRINT Campionato(DaySel).Punteggio_S

	LOCATE , 20
	COLOR 15, 3: PRINT "Data partita: ";
	MenuGiornata(5).Y = CSRLIN
	MenuGiornata(5).X = POS(1)
	MenuGiornata(5).D = 10
	MenuGiornata(5).C = 15
	MenuGiornata(5).t = Campionato(DaySel).DataPartita

	COLOR 15, 0: PRINT Campionato(DaySel).DataPartita

	Win 40, 16, 46, 4, 3, 15, FALSE
	
	LOCATE 13, 48: PRINT "PtP+P-Gp";
	LOCATE 13, 18: PRINT "N";
	LOCATE , 22: PRINT "Nome";

	COLOR 14, 3
	LOCATE 20, 22: PRINT "[CR]";
	COLOR 15, 3: PRINT " OK   ";
	COLOR 14, 3: PRINT "[ESC]";
	COLOR 15, 3: PRINT " Annulla  ";
	COLOR 14, 3: PRINT "[F12]";
	COLOR 15, 3: PRINT " Stampa ";

	IF PlyrSel + 5 < UBOUND(Squadra) THEN
		Riga = PlyrSel
	ELSE
		IF UBOUND(Squadra) > 5 THEN
			Riga = UBOUND(Squadra) - 5
		ELSE
			Riga = 1
		END IF
	END IF

	PlayerSel = PlyrSel

	IF UBOUND(Squadra) THEN
		FOR Index = 1 TO 4
			MenuGiornata(Index + 5).Y = 14
			MenuGiornata(Index + 5).X = 45 + 3 * Index
			MenuGiornata(Index + 5).D = 2
			MenuGiornata(Index + 5).C = 15
			MenuGiornata(Index + 5).t = STR$(ASC(MID$(Squadra(Riga).Risultati, DaySel * 3 - 3 + Index)))
		NEXT
		MenuGiornata(9).D = 1
		MenuGiornata(9).t = STR$(ASC(MID$(Squadra(Riga).Risultati, DaySel * 3 - 3 + Index)))


		FOR Index = 1 TO UBOUND(Squadra)
			DummyValues(0, Index) = ASC(MID$(Squadra(Index).Risultati, DaySel * 3 - 2, 1)) AND 127
			DummyValues(1, Index) = ASC(MID$(Squadra(Index).Risultati, DaySel * 3 - 1, 1))
			DummyValues(2, Index) = ASC(MID$(Squadra(Index).Risultati, DaySel * 3, 1))
			DummyValues(3, Index) = (ASC(MID$(Squadra(Index).Risultati, DaySel * 3 - 2, 1)) AND 128) \ 128
		NEXT

		MostraListaGiornata Riga, DummyValues()

	END IF

	
	DO
		IF Selected < 1 THEN Selected = 1
		IF Selected > UBOUND(MenuGiornata) THEN Selected = UBOUND(MenuGiornata)     'Limiti per la selezione campo di inserimento.

		IF PlayerSel < 1 THEN PlayerSel = 1
		IF PlayerSel > UBOUND(Squadra) THEN PlayerSel = UBOUND(Squadra)             'Limiti per la selezione giocatore.

		IF UBOUND(Squadra) = 0 THEN
			PlayerSel = 0
			OldSel = 0
			IF Selected > 5 THEN Selected = 5
		END IF

		VscrollBar 63, 16, 4, 3, 15, PlayerSel / UBOUND(Squadra) * 100


		IF PlayerSel <> OldSel THEN
			IF OldSel THEN LineEvidences 20, 13 + OldSel - Riga, 24
			OldSel = PlayerSel
			IF PlayerSel > Riga + 4 THEN        'Scroll verso il basso
				Riga = Riga + 1
				MostraListaGiornata Riga, DummyValues()
			END IF
			IF PlayerSel < Riga THEN            'Scroll verso il basso
				Riga = Riga - 1
				MostraListaGiornata Riga, DummyValues()
			END IF

			LineEvidences 20, 13 + PlayerSel - Riga, 24
			FOR Index = 6 TO 9
				MenuGiornata(Index).Y = 14 + PlayerSel - Riga
			NEXT
			MenuGiornata(6).t = LTRIM$(STR$(DummyValues(0, PlayerSel)))       'Impostazione dei valori corretti nei campi di menu.
			MenuGiornata(7).t = LTRIM$(STR$(DummyValues(1, PlayerSel)))
			MenuGiornata(8).t = LTRIM$(STR$(DummyValues(2, PlayerSel)))
			MenuGiornata(9).t = LTRIM$(STR$(DummyValues(3, PlayerSel)))
			
		END IF

		ActualContent = ZTrim$(MenuGiornata(Selected).t)                           'Introduzione dei dati.
		COLOR MenuGiornata(Selected).C, 7

		LOCATE MenuGiornata(Selected).Y, MenuGiornata(Selected).X
		
		in = MaskedInput(TRUE, MenuGiornata(Selected).D, ActualContent, TRUE)
		MenuGiornata(Selected).t = ActualContent
		COLOR MenuGiornata(Selected).C, 0
		LOCATE MenuGiornata(Selected).Y, MenuGiornata(Selected).X
		PRINT LEFT$(MenuGiornata(Selected).t, MenuGiornata(Selected).D)

		IF Selected > 5 THEN                'Impostazione dei valori dummy per i punteggi giocatori.
			DummyValues(Selected - 6, PlayerSel) = VAL(ActualContent)
		END IF

		SELECT CASE in
			CASE CHR$(9)                '[TAB]
				Selected = Selected + 1

			CASE CHR$(0) + CHR$(15)     '[SHIFT][TAB]
				Selected = Selected - 1

			CASE CHR$(0) + CHR$(72)     '[UP]
				IF Selected > 5 THEN
					PlayerSel = PlayerSel - 1
				END IF

			CASE CHR$(0) + CHR$(80)     '[DOWN]
				IF Selected > 5 THEN
					PlayerSel = PlayerSel + 1
				END IF

			CASE CHR$(0) + CHR$(77)     '[Right]
				IF Selected > 5 THEN Selected = Selected + 1

			CASE CHR$(0) + CHR$(75)     '[Left]
				IF Selected > 6 THEN Selected = Selected - 1
			
			CASE CHR$(13)               '[Invio]
				EXIT DO

			CASE CHR$(27)               '[ESC]
				IF PlayerSel THEN LineEvidences 19, 13 + PlayerSel - Riga, 24
				ScreenRestore Scrn()
				EXIT SUB

			CASE CHR$(0) + CHR$(134)'F12
				Campionato(DaySel).Avversario = MenuGiornata(1).t       'Salva dati in memoria
				Campionato(DaySel).Punteggio_A = MenuGiornata(2).t
				Campionato(DaySel).Punteggio_S = MenuGiornata(3).t

				Campionato(DaySel).Goal_S = CalcolaGoal(Campionato(DaySel).Punteggio_S)
				Campionato(DaySel).Goal_A = CalcolaGoal(Campionato(DaySel).Punteggio_A)

				FOR Index = 1 TO UBOUND(Squadra)            'Ripristino dei valori
					MID$(Squadra(Index).Risultati, DaySel * 3 - 2, 1) = CHR$(DummyValues(0, Index) + ABS((DummyValues(3, Index) > 0) * 128))
					MID$(Squadra(Index).Risultati, DaySel * 3 - 1, 1) = CHR$(DummyValues(1, Index))
					MID$(Squadra(Index).Risultati, DaySel * 3, 1) = CHR$(DummyValues(2, Index))
				NEXT

				PStampaVoti

			CASE CHR$(0) + CHR$(59)'[F1]
				Help 40, 12, 60, 15, "fanta.hlp", "IMPOSTA_GIORNATA", 4, 15




		END SELECT

	LOOP

	IF PlayerSel THEN LineEvidences 20, 13 + PlayerSel - Riga, 24
	ScreenRestore Scrn()
	Campionato(DaySel).Avversario = MenuGiornata(1).t
	Campionato(DaySel).InCasa = MenuGiornata(2).t
	Campionato(DaySel).Punteggio_A = MenuGiornata(3).t
	Campionato(DaySel).Punteggio_S = MenuGiornata(4).t
	Campionato(DaySel).DataPartita = MenuGiornata(5).t

	Campionato(DaySel).Goal_S = CalcolaGoal(Campionato(DaySel).Punteggio_S)
	Campionato(DaySel).Goal_A = CalcolaGoal(Campionato(DaySel).Punteggio_A)

	FOR Index = 1 TO UBOUND(Squadra)            'Ripristino dei valori
		MID$(Squadra(Index).Risultati, DaySel * 3 - 2, 1) = CHR$(DummyValues(0, Index) + ABS((DummyValues(3, Index) > 0) * 128))
		MID$(Squadra(Index).Risultati, DaySel * 3 - 1, 1) = CHR$(DummyValues(1, Index))
		MID$(Squadra(Index).Risultati, DaySel * 3, 1) = CHR$(DummyValues(2, Index))
	NEXT

	MostraGiocatori PlyrRow
	
END SUB

SUB ImpostaPercentuali ()
	DIM Scrn(4000) AS INTEGER
	DIM Percentuale AS STRING
	DIM ActualContent AS STRING
	DIM in AS STRING
	
	ScreenSave Scrn()
	Win 40, 12, 40, 6, 3, 15, TRUE

	Center 8, " Impostazione criteri formazione "

	COLOR 15, 3
	LOCATE 11, 22: PRINT "Valutazione presenze: ";
	LOCATE 11, 46
	COLOR 15, 0: PRINT "   "

	COLOR 15, 3
	LOCATE 12, 22: PRINT "Valutazione rendimento: ";
	LOCATE 12, 45: PRINT STR$(100 - Perc) + "%  "

	COLOR 14, 3: LOCATE 15, 22: PRINT "[CR] ";
	COLOR 15, 3: PRINT "OK    ";
	COLOR 14, 3: PRINT "[ESC] ";
	COLOR 15, 3: PRINT "Annulla  ";
	COLOR 14, 3: PRINT "[F1] ";
	COLOR 15, 3: PRINT "Help"
	
	Percentuale = LTRIM$(STR$(Perc))
	DO
		COLOR 15, 0
		ActualContent = ZTrim$(Percentuale)
		LOCATE 11, 46
		in = MaskedInput(TRUE, 3, ActualContent, TRUE)
		Percentuale = ActualContent
		COLOR 15, 3

		IF VAL(Percentuale) <= 100 THEN
			Perc = VAL(Percentuale)
			COLOR 15, 3
			LOCATE 12, 45: PRINT STR$(100 - Perc) + "%   "
		END IF

		
		SELECT CASE in

			CASE CHR$(13)
				EXIT DO

			CASE CHR$(27)
				ScreenRestore Scrn()
				EXIT SUB

			CASE CHR$(0) + CHR$(59)'[F1]
				Help 40, 12, 60, 15, "fanta.hlp", "IMPOSTA_PERCENTUALI", 4, 15


		END SELECT

	LOOP

	


	
	ScreenRestore Scrn()
END SUB

FUNCTION InSquadra (Player AS INTEGER) AS INTEGER

	'Verifica se un giocatore  nella formazione della giornata attuale

	DIM Index AS INTEGER
	'IF NOT Player THEN EXIT FUNCTION
	FOR Index = 1 TO 16
		IF UCASE$(LEFT$(Campionato(DaySel).Formazione(Index), 19)) = UCASE$(Squadra(Player).Nome) THEN
			IF Index > 11 THEN
				InSquadra = 2
			ELSE
				InSquadra = 1
			END IF
			EXIT FUNCTION
		END IF
	NEXT
	
END FUNCTION

SUB LoadT ()
	DIM NomeFile AS STRING

	NomeFile = UCASE$(FileName)

	InputBox 40, 12, 40, "File da caricare", 4, 15, NomeFile
	IF INSTR(NomeFile, CHR$(27)) THEN EXIT SUB

	LoadFile NomeFile

	ScrollWindow 20, 1, 1, 78, 9, 1 * 16 + 15
	ScrollWindow 20, 1, 11, 78, 18, 1 * 16 + 15

	PlyrSel = 0
	PlyrRow = 1
	DayRow = 1

	MostraGiocatori PlyrRow
	MostraGiornate DayRow

	DIM Fl AS INTEGER
	ON LOCAL ERROR RESUME NEXT

	Fl = FREEFILE
	OPEN "Files.dat" FOR OUTPUT AS #Fl
		PRINT #Fl, NomeFile
		PRINT #Fl, STR$(Perc)
		PRINT #Fl, MedieConGoal
	CLOSE #Fl

	FileName = NomeFile


END SUB

SUB Mask ()
COLOR 15, 1                             ' Disegno schermata e men

CLS
Win 41, 10, 78, 17, 1, 7, FALSE

LOCATE 10
PRINT "" + STRING$(78, "") + ""
Center 11, " Giornate di campionato "
Center 1, " Giocatori in squadra "

VscrollBar 80, 15, 7, 1, 7, 0
VscrollBar 80, 6, 8, 1, 7, 0


COLOR 15, 1
LOCATE 21, 2: PRINT "G";
COLOR 14, 1: PRINT "o";
COLOR 15, 1: PRINT "al ",
COLOR 14, 1: PRINT " G";
COLOR 15, 1: PRINT "iornata ",
COLOR 14, 1: PRINT " F";
COLOR 15, 1: PRINT "ormazione ",
COLOR 14, 1: PRINT " V";
COLOR 15, 1: PRINT "is. medie",
PRINT

LOCATE , 2: PRINT "G";
COLOR 14, 1: PRINT "i";
COLOR 15, 1: PRINT "ocatore ",
PRINT " S";
COLOR 14, 1: PRINT "q";
COLOR 15, 1: PRINT "uadra ",

PRINT " S";
COLOR 14, 1: PRINT "t";
COLOR 15, 1: PRINT "atistiche ",

PRINT

COLOR 14, 1
LOCATE , 2: PRINT "C";
COLOR 15, 1: PRINT "arica ",
COLOR 14, 1: PRINT " S";
COLOR 15, 1: PRINT "alva ",
COLOR 14, 1: PRINT " E";
COLOR 15, 1: PRINT "sci ",
PRINT " S";
COLOR 14, 1: PRINT "h";
COLOR 15, 1: PRINT "ell",

LOCATE 21, 63: COLOR 7, 1
PRINT "Copyright 1996/98"
LOCATE , 63
PRINT "B.d. software"
LOCATE , 63
PRINT "Versione 1.4b"

COLOR 15, 3
LOCATE 25, 1: PRINT SPACE$(80);
LOCATE 25, 1
PRINT "[F1] - Help  [ESC] - Menu   [F6] o [TAB] - Cambia finestra   [F12] - Stampa";
END SUB

SUB Menu ()
	DIM MenuCol AS INTEGER
	DIM MenuRow AS INTEGER
	DIM OldMRow AS INTEGER
	DIM OldMCol AS INTEGER

	DIM X AS INTEGER, oX AS INTEGER        ' Variabili usate per il mouse
	DIM Y AS INTEGER, oY AS INTEGER
	DIM Lb AS INTEGER, oLb AS INTEGER
	DIM Rb AS INTEGER, oRb AS INTEGER
	DIM BadCoords AS INTEGER               ' Flag: il mouse si trova su un item o no
	DIM StartFlag AS INTEGER               ' Flag: prima esecuzione del ciclo (processa il mouse)

	DIM in AS STRING
	StartFlag = TRUE
	LineEvidences 14 * MenuCol, 20 + MenuRow, 12
	MousePoll Y, X, Lb, Rb
	DO
		IF OldMRow <> MenuRow OR OldMCol <> MenuCol THEN
			LineEvidences 14 * OldMCol, 20 + OldMRow, 12
			LineEvidences 14 * MenuCol, 20 + MenuRow, 12
		END IF

		OldMRow = MenuRow
		OldMCol = MenuCol


		DO
			in = INKEY$

			oX = X: oY = Y: oLb = Lb: oRb = Rb
			MousePoll Y, X, Lb, Rb
			IF (oX <> X) OR (oY <> Y) OR StartFlag THEN  ' Se il mouse si  spostato (oppure se  la prima esecuzione)
				MenuRow = Y - 21            ' calcola l'item su cui si trova il cursore
				IF MenuRow >= 0 AND MenuRow <= 2 THEN
					MenuCol = X \ 14
				END IF
				BadCoords = FALSE
				in = CHR$(0)
			END IF
			IF oLb = TRUE AND Lb = FALSE THEN
				IF NOT (BadCoords) THEN in = CHR$(13)
			END IF
			StartFlag = FALSE
			
		LOOP WHILE in = ""
		IF ((oY <> Y) OR (oX <> X)) AND Y < 20 THEN
			EXIT DO
		END IF
		SELECT CASE in
			CASE CHR$(0) + CHR$(77) 'Right
				MenuCol = MenuCol + 1

			CASE CHR$(0) + CHR$(75) 'Left
				MenuCol = MenuCol - 1

			CASE CHR$(0) + CHR$(72) 'Up
				MenuRow = MenuRow - 1

			CASE CHR$(0) + CHR$(80) 'Down
				MenuRow = MenuRow + 1

			CASE CHR$(0) + CHR$(59)'[F1]
				Help 40, 12, 60, 15, "fanta.hlp", "MENU_CAMPIONATO", 4, 15

			CASE CHR$(27)           '[ESC]

				EXIT DO

			CASE CHR$(13)
				IF MenuRow = 0 AND MenuCol = 0 THEN StatGoals: EXIT DO
				IF MenuRow = 0 AND MenuCol = 1 THEN
					LineEvidences 14 * MenuCol, 20 + MenuRow, 12
					ImpostaGiornata
					MostraGiornate DayRow
					LineEvidences 14 * MenuCol, 20 + MenuRow, 12
					EXIT DO
				END IF
				IF MenuRow = 0 AND MenuCol = 2 THEN ImpostaFormazione: EXIT DO
				IF MenuRow = 0 AND MenuCol = 3 THEN MedieConGoal = NOT (MedieConGoal): MostraGiocatori PlyrRow: EXIT DO
				IF MenuRow = 1 AND MenuCol = 0 THEN StatPlayer: EXIT DO
				IF MenuRow = 1 AND MenuCol = 1 THEN StatTeam: EXIT DO
				IF MenuRow = 2 AND MenuCol = 0 THEN LoadT: EXIT DO
				IF MenuRow = 2 AND MenuCol = 1 THEN SaveT: EXIT DO
				IF MenuRow = 2 AND MenuCol = 2 THEN ExitProgram: EXIT DO
				IF MenuRow = 2 AND MenuCol = 3 THEN DosShell: EXIT DO
				IF MenuRow = 1 AND MenuCol = 2 THEN StatNumeri: EXIT DO


		END SELECT

		IF MenuCol < 0 THEN MenuCol = 0: BadCoords = TRUE
		IF MenuRow > 2 THEN MenuRow = 2: BadCoords = TRUE
		IF MenuRow < 0 THEN MenuRow = 0: BadCoords = TRUE
		

		IF MenuRow = 1 THEN
			IF MenuCol > 2 THEN MenuCol = 2: BadCoords = TRUE
		ELSEIF MenuRow = 2 THEN
			IF MenuCol > 3 THEN MenuCol = 3: BadCoords = TRUE
		ELSE
			IF MenuCol > 3 THEN MenuCol = 3: BadCoords = TRUE
		END IF

	LOOP

	LineEvidences 14 * OldMCol, 20 + OldMRow, 12
	MostraGiornate DayRow
	MostraGiocatori PlyrRow


END SUB

SUB MostraGiocatori (Riga AS INTEGER)

	DIM Index AS INTEGER

	COLOR 12, 1
	IF MedieConGoal THEN
		LOCATE 1, 65: PRINT "Medie complete"
	ELSE
		LOCATE 1, 65: PRINT "Medie nette   "
	END IF
	
	LOCATE 2
	FOR Index = Riga TO Riga + 8
		IF Index > UBOUND(Squadra) THEN EXIT FOR
		StampaNome Index
	NEXT


END SUB

SUB MostraGiornate (Riga AS INTEGER)

'Mostra le giornate giocate / da giocare

DIM Index AS INTEGER
DIM P_Avv AS INTEGER
DIM P_Squ AS INTEGER

LOCATE 12
FOR Index = Riga TO Riga + 7
	IF Index > UBOUND(Campionato) THEN EXIT FOR
	StampaGiornata Index

NEXT

END SUB

SUB MostraListaGiornata (Riga AS INTEGER, DummyValues() AS INTEGER)

'Visualizzazione della lista dei giocatori all'interno della finestra di
'impostazione della giornata.

DIM Index AS INTEGER
DIM Dummy AS STRING * 2
DIM D AS INTEGER

FOR Index = Riga TO Riga + 4                    'Visualizzazione giocatori in lista
	IF Index > UBOUND(Squadra) THEN EXIT FOR

	'PRINT InSquadra(Index)
	SELECT CASE InSquadra(Index)

		CASE 1  'Giocatore in campo
			COLOR 0, 3

		CASE 2  'Giocatore in panchina
			COLOR 14, 3

		CASE 0  'Giocatore non in formazione
			COLOR 15, 3

	END SELECT
	LOCATE Index - Riga + 14, 18: PRINT Squadra(Index).Numero; "  ";
	PRINT Squadra(Index).Nome;

	COLOR 15, 0

	Dummy = LTRIM$(STR$(DummyValues(0, Index)))     'L'utilizzo di una variabile dummy consente di ottenere facilmente
	LOCATE , 48: PRINT Dummy;                       'la formattazione entro due caratteri
	Dummy = LTRIM$(STR$(DummyValues(1, Index)))
	LOCATE , 51: PRINT Dummy;
	Dummy = LTRIM$(STR$(DummyValues(2, Index)))
	LOCATE , 54: PRINT Dummy;
	LOCATE , 57: PRINT LTRIM$(STR$(DummyValues(3, Index)));
NEXT

END SUB

FUNCTION PartitaGiocata (Index AS INTEGER)

IF VAL(Campionato(Index).Punteggio_S) <> 0 THEN
	PartitaGiocata = TRUE
 ELSE
	'STOP
 END IF



END FUNCTION

SUB PIntestazione (Fl AS INTEGER)
'Stampa una intestazione sul foglio

	ON LOCAL ERROR RESUME NEXT

	PRINT #Fl, "                    Gestione Fantacalcio campionato 1997-98"
	PRINT #Fl, "              (C) 1996-8 B.d. software. Tutti i diritti riservati."
	IF DEMO THEN
		PRINT #Fl, "                            VERSIONE DIMOSTRATIVA             "
	END IF
	PRINT #Fl,

END SUB

SUB PStampaFormazione ()
ON LOCAL ERROR RESUME NEXT

DIM Index AS INTEGER
DIM Fl AS INTEGER

ON LOCAL ERROR RESUME NEXT

Fl = FREEFILE

OPEN Printr FOR OUTPUT AS #Fl
	PIntestazione Fl
	PRINT #Fl, "   Formazione giornata n: "; DaySel
	PRINT #Fl, "   Modulo: "; Campionato(DaySel).TipoFormazione
	PRINT #Fl,
	PRINT #Fl, "   Giocatori in campo ed in panchina:"
	PRINT #Fl, STRING$(75, "-")
	
	FOR Index = 1 TO 11
		PRINT #Fl, "   "; Campionato(DaySel).Formazione(Index)
	NEXT
	PRINT #Fl, STRING$(75, "-")
	
	FOR Index = 12 TO 16
		PRINT #Fl, "   "; Campionato(DaySel).Formazione(Index)
	NEXT
	PRINT #Fl, STRING$(75, "-")
CLOSE #Fl

IF ERR THEN Msg 40, 12, "Stampante non pronta"

END SUB

SUB PStampaGiornate ()

' Stampa la lista delle giornate
DIM Fl AS INTEGER
DIM Index AS INTEGER

ON LOCAL ERROR RESUME NEXT

Fl = FREEFILE

OPEN Printr FOR OUTPUT AS #Fl
	PIntestazione Fl
	PRINT #Fl, "   Giornate di campionato:"
	PRINT #Fl, "   "
	PRINT #Fl, "  N  Avversario            pts  pta  gs ga Risultato  "
	PRINT #Fl, STRING$(75, "-")
	FOR Index = 1 TO UBOUND(Campionato)
		PRINT #Fl, USING "  ##  "; Index;
		PRINT #Fl, Campionato(Index).Avversario;
		IF LTRIM$(ZTrim$(Campionato(Index).Avversario)) <> "" THEN
			PRINT #Fl, "  "; Campionato(Index).Punteggio_S;
			PRINT #Fl, "  "; Campionato(Index).Punteggio_A;
			PRINT #Fl, "  "; Campionato(Index).Goal_S;
			PRINT #Fl, "  "; Campionato(Index).Goal_A;
			IF VAL(Campionato(Index).Goal_S) < VAL(Campionato(Index).Goal_A) THEN
				PRINT #Fl, "  Sconfitta";
			ELSEIF VAL(Campionato(Index).Goal_S) > VAL(Campionato(Index).Goal_A) THEN
				PRINT #Fl, "  Vittoria";
			ELSE
				PRINT #Fl, "  Pareggio";
			END IF
		END IF
		PRINT #Fl, "   "
	NEXT
	PRINT #Fl, STRING$(75, "-")
	PRINT #Fl, " pts=punti squadra; pta=punti avv.; gs=goal segnati; ga=goal avv."
CLOSE #Fl
IF ERR THEN Msg 40, 12, "Stampante non pronta"

END SUB

SUB PStampaGoleador (STeam() AS INTEGER)


DIM Fl AS INTEGER
DIM Index AS INTEGER

ON LOCAL ERROR RESUME NEXT

Fl = FREEFILE

OPEN Printr FOR OUTPUT AS #Fl
	PIntestazione Fl
	PRINT #Fl, "   Classifaica GOLEADOR"
	PRINT #Fl,
	PRINT #Fl, STRING$(75, "-")
	FOR Index = 1 TO UBOUND(Squadra)
		PRINT #Fl, "  "; Squadra(STeam(Index)).Numero; "  ";
		PRINT #Fl, Squadra(STeam(Index)).Nome;
		PRINT #Fl, "            "; Squadra(STeam(Index)).Tipo; "       ";
		IF UCASE$(Squadra(STeam(Index)).Tipo) = "P" THEN
		
			PRINT #Fl, CalcolaGoalSubiti(STeam(Index));

		ELSE
			PRINT #Fl, "   ";
		END IF


		PRINT #Fl, "     "; CalcolaGoalSegnati(STeam(Index))
	NEXT
	PRINT #Fl, STRING$(75, "-")
CLOSE #Fl

IF ERR THEN Msg 40, 12, "Stampante non pronta"

END SUB

SUB PStampaSquadra ()

'Stampa la lista dei giocatori

DIM Fl AS INTEGER
DIM Index AS INTEGER
DIM TIndex AS INTEGER
DIM Voto AS INTEGER
DIM presenze AS INTEGER
DIM V AS INTEGER

ON LOCAL ERROR RESUME NEXT

Fl = FREEFILE
OPEN Printr FOR OUTPUT AS #Fl
	PIntestazione Fl
	PRINT #Fl, "   Giocatori in squadra:"
	PRINT #Fl, "   "
	PRINT #Fl, "  N  Nome                 R.  Presenze                        Pr.  Media"
	PRINT #Fl, STRING$(75, "-")
	FOR Index = 1 TO UBOUND(Squadra)
		PRINT #Fl, "  "; Squadra(Index).Numero;
		PRINT #Fl, "  "; Squadra(Index).Nome;
		PRINT #Fl, " "; Squadra(Index).Tipo; "   ";

		presenze = 0
		Voto = 0

		FOR TIndex = 1 TO 30
			V = ASC(MID$(Squadra(Index).Risultati, TIndex * 3 - 2, 1))
			IF V THEN
				IF V AND 128 THEN
					PRINT #Fl, "*";
					V = V AND 127
				ELSE
					PRINT #Fl, "+";
				END IF
				presenze = presenze + 1
				Voto = Voto + V
			ELSE
					PRINT #Fl, " ";
			END IF
		NEXT
		PRINT #Fl, USING " ## "; presenze;
		IF presenze > 0 THEN
			PRINT #Fl, USING "   ##.##"; Voto / presenze;
		END IF
		PRINT #Fl, "   "

	NEXT
	PRINT #Fl, STRING$(75, "-")
	PRINT #Fl, "  * = presenza in squadra     + = presenza in campionato"
CLOSE #Fl

IF ERR THEN Msg 40, 12, "Stampante non pronta"
END SUB

SUB PStampaStatistica ()
'Stampa l'istogramma di voti del giocatore selezionato.

DIM Fl AS INTEGER
DIM Index AS INTEGER
DIM Voto AS INTEGER
DIM Bonus AS INTEGER
DIM Malus AS INTEGER
DIM Car AS STRING * 1
ON LOCAL ERROR RESUME NEXT

IF MedieConGoal THEN
	Car = "+"
ELSE
	Car = "*"
END IF


Fl = FREEFILE

OPEN Printr FOR OUTPUT AS #Fl
	PIntestazione Fl

	PRINT #Fl, "    Grafico voti giocatore per giornata"
	PRINT #Fl, "    Nome Giocatore: "; Squadra(PlyrSel).Nome
	PRINT #Fl,
	PRINT #Fl, " Giorn.  Risultati"
	PRINT #Fl, STRING$(5, "-"); "0"; STRING$(4, "-"); "1";
	PRINT #Fl, STRING$(5, "-"); "2"; STRING$(5, "-"); "3";
	PRINT #Fl, STRING$(4, "-"); "4"; STRING$(4, "-"); "5";
	PRINT #Fl, STRING$(5, "-"); "6"; STRING$(5, "-"); "7";
	PRINT #Fl, STRING$(4, "-"); "8"; STRING$(4, "-"); "9";
	PRINT #Fl, STRING$(4, "-"); "10"; STRING$(15, "-")

	FOR Index = 1 TO 30
		Voto = ASC(MID$(Squadra(PlyrSel).Risultati, Index * 3 - 2, 1)) AND 127
		IF MedieConGoal THEN
			Bonus = ASC(MID$(Squadra(PlyrSel).Risultati, Index * 3 - 1, 1)) AND 127
			Malus = ASC(MID$(Squadra(PlyrSel).Risultati, Index * 3 - 0, 1)) AND 127
			Voto = Voto + Bonus - Malus
		END IF

		PRINT #Fl, USING "   ## "; Index;
		PRINT #Fl, STRING$(55 / 100 * Voto, Car);
		IF Voto > 0 THEN
			PRINT #Fl, USING " ##.#"; Voto / 10
		ELSE
			PRINT #Fl,
		END IF
	NEXT

	PRINT #Fl, STRING$(75, "-")
	IF MedieConGoal THEN
		PRINT #Fl, "      Voti comprensivi di bonus e penalit"
	ELSE
		PRINT #Fl, "      Voti netti"
	END IF

CLOSE #Fl

IF ERR THEN Msg 40, 12, "Stampante non pronta"
END SUB

SUB PStampaStatTeam ()

'Stampa il grafico dell'andamento della squadra giornata per giornata

DIM Fl AS INTEGER
DIM Index AS INTEGER
DIM P_Avv AS INTEGER
DIM P_Squ AS INTEGER
DIM Risultati AS INTEGER

ON LOCAL ERROR RESUME NEXT

Fl = FREEFILE

OPEN Printr FOR OUTPUT AS #Fl
	PIntestazione Fl

	PRINT #Fl, "    Grafico andamento squadra per giornata"
	PRINT #Fl,
	PRINT #Fl, " Giorn."; SPACE$(25); "-     0     +"
	PRINT #Fl, STRING$(75, "-")

	FOR Index = 1 TO 30
		PRINT #Fl, Index;
		IF LTRIM$(ZTrim$(Campionato(Index).Avversario)) <> "" THEN

			P_Avv = VAL(Campionato(Index).Goal_A)
			P_Squ = VAL(Campionato(Index).Goal_S)

			IF P_Avv = P_Squ THEN

			ELSEIF P_Avv < P_Squ THEN
				Risultati = Risultati + 1
			ELSE
				Risultati = Risultati - 1
			END IF
			
			PRINT #Fl, STRING$(Risultati + 35, " "); "*";
			'PRINT Risultati
			'DO: LOOP WHILE INKEY$ = ""
		END IF
		PRINT #Fl,

	NEXT

	PRINT #Fl, STRING$(75, "-")

CLOSE #Fl

IF ERR THEN Msg 40, 12, "Stampante non pronta"

END SUB

SUB PStampaVoti ()

' Stampa tutte le votazioni di una giornata

DIM Fl AS INTEGER
DIM Index AS INTEGER

ON LOCAL ERROR RESUME NEXT

Fl = FREEFILE

OPEN Printr FOR OUTPUT AS #Fl
	PIntestazione Fl
	PRINT #Fl, "   Giornata n "; DaySel
	PRINT #Fl, "   Votazioni totalizzate dai giocatori:"
	PRINT #Fl,
	PRINT #Fl, "   N  Nome                 Pt  P+  P-  Presenza in squadra"

	PRINT #Fl, STRING$(75, "-")
	FOR Index = 1 TO UBOUND(Squadra)
		PRINT #Fl, "   "; Squadra(Index).Numero;
		PRINT #Fl, "  "; Squadra(Index).Nome;
		PRINT #Fl, USING " ## "; ASC(MID$(Squadra(Index).Risultati, DaySel * 3 - 2, 1)) AND 127;
		PRINT #Fl, USING " ## "; ASC(MID$(Squadra(Index).Risultati, DaySel * 3 - 1, 1));
		PRINT #Fl, USING " ## "; ASC(MID$(Squadra(Index).Risultati, DaySel * 3, 1));
		IF ASC(MID$(Squadra(Index).Risultati, DaySel * 3 - 2, 1)) > 128 THEN
			PRINT #Fl, "        Si";
		END IF

		PRINT #Fl,
	NEXT
	PRINT #Fl, STRING$(75, "-")
CLOSE #Fl

IF ERR THEN Msg 40, 12, "Stampante non pronta"

END SUB

SUB RuoliGiocatori (Modulo AS STRING)

DIM Formula AS STRING
DIM Index AS INTEGER

Formula = SPACE$(30)

SELECT CASE Modulo
	CASE "4 4 2"
		Formula = "PDDDDCCCCAA"

	CASE "4 3 3"
		Formula = "PDDDDCCCAAA"

	CASE "5 4 1"
		Formula = "PDDDDDCCCCA"

	CASE "5 3 2"
		Formula = "PDDDDDCCCAA"

	CASE "6 3 1"
		Formula = "PDDDDDDCCCA"

	CASE "3 4 3"
		Formula = "PDDDCCCCAAA"

	CASE "3 5 2"
		Formula = "PDDDCCCCCAA"
	
END SELECT

COLOR 15, 3
FOR Index = 2 TO 12
	LOCATE MenuFormazione(Index).Y, MenuFormazione(Index).X + 23
	PRINT MID$(Formula, Index - 1, 1);
NEXT

END SUB

SUB SaveT ()

	DIM NomeFile AS STRING
	NomeFile = UCASE$(FileName)

	InputBox 40, 12, 40, "File da salvare", 4, 15, NomeFile
	IF INSTR(NomeFile, CHR$(27)) THEN EXIT SUB

	SaveFile NomeFile

	DIM Fl AS INTEGER
	ON LOCAL ERROR RESUME NEXT

	Fl = FREEFILE
	OPEN "Files.dat" FOR OUTPUT AS #Fl
		PRINT #Fl, NomeFile
		PRINT #Fl, STR$(Perc)
		PRINT #Fl, MedieConGoal
	CLOSE #Fl

	FileName = NomeFile

	IF ERR THEN Msg 40, 12, "Errore: " + STR$(ERR)

END SUB

SUB SortPlayer (STeam() AS INTEGER, TypeS AS INTEGER)

'Ottieni una lista di giocatori in ordine decrescente
'TypeS = 0; Lista ordinata per punteggio medio
'TypeS = 1; Lista ordinata per numero di goal
	
	DIM Index AS INTEGER
	DIM TIndex AS INTEGER
	
	DIM Medie(UBOUND(Squadra))  AS INTEGER

	IF TypeS = 0 THEN
		FOR Index = 1 TO UBOUND(Squadra)
			Medie(Index) = CLNG(CalcolaMedia(Index)) * (100 - CLNG(Perc)) / 100 + CalcolaPresenze(Index) * Perc
			STeam(Index) = Index
		NEXT
	ELSE
		FOR Index = 1 TO UBOUND(Squadra)
			Medie(Index) = CalcolaGoalSegnati(Index)
			STeam(Index) = Index
		NEXT
	END IF


	' Algoritmo SELECTION-SORT
	
	DIM Max AS INTEGER

	FOR Index = 1 TO UBOUND(Squadra)
		Max = Index
		FOR TIndex = Index + 1 TO UBOUND(Squadra)
			IF Medie(TIndex) > Medie(Max) THEN
				Max = TIndex
			END IF
		NEXT
		SWAP Medie(Max), Medie(Index)
		SWAP STeam(Max), STeam(Index)
 
	NEXT

	
END SUB

SUB StampaGiornata (Index AS INTEGER)

	DIM P_Avv AS INTEGER
	DIM P_Squ AS INTEGER


	COLOR 15, 1
	LOCATE , 3: PRINT USING "##   "; Index;
	PRINT Campionato(Index).Avversario; "  ";
	PRINT Campionato(Index).InCasa; "    ";
	
	IF PartitaGiocata(Index) THEN             'Stampa risultati se partita giocata
		COLOR 14, 1
		PRINT Campionato(Index).Punteggio_S; "    ";
		COLOR 12, 1
		PRINT Campionato(Index).Punteggio_A; "    ";
		COLOR 14, 1
		PRINT Campionato(Index).Goal_S; "   ";
		COLOR 12, 1
		PRINT Campionato(Index).Goal_A; "   ";
		P_Avv = VAL(Campionato(Index).Goal_A)
		P_Squ = VAL(Campionato(Index).Goal_S)

		IF P_Avv = P_Squ THEN
			COLOR 15
			PRINT "Pareggio     ";        'Gli spazi in eccesso servono a sovrascrivere le scritte precedenti
		ELSEIF P_Avv < P_Squ THEN
			COLOR 14
			PRINT "Vittoria     ";
		ELSE
			COLOR 12
			PRINT "Sconfitta    ";
		END IF

		COLOR 15
		PRINT Campionato(Index).DataPartita;
	ELSE
		PRINT SPACE$(46);
	END IF

	PRINT

END SUB

SUB StampaNome (SIndex AS INTEGER)

	DIM TIndex AS INTEGER
	DIM presenze AS INTEGER
	DIM Voto AS INTEGER
	DIM Media AS SINGLE
	DIM V AS INTEGER

	LOCATE , 4
	COLOR 15, 1
	PRINT Squadra(SIndex).Numero; "  ";
	IF Squadra(SIndex).Straniero = "S" THEN COLOR 14, 1
	PRINT Squadra(SIndex).Nome; "  ";
	COLOR 15, 1
	PRINT Squadra(SIndex).Tipo; "      ";
	
	FOR TIndex = 1 TO 30
	V = ASC(MID$(Squadra(SIndex).Risultati, TIndex * 3 - 2, 1))
	IF V THEN
		IF V AND 128 THEN
			COLOR 12
			PRINT "*";
			V = V AND 127
		ELSE
			COLOR 15
			PRINT "+";
		END IF
		presenze = presenze + 1
		Voto = Voto + V
		IF MedieConGoal THEN
			Voto = Voto + (ASC(MID$(Squadra(SIndex).Risultati, TIndex * 3 - 1, 1)) AND 127)
			Voto = Voto - (ASC(MID$(Squadra(SIndex).Risultati, TIndex * 3, 1)) AND 127)
		END IF

		ELSE
			PRINT " ";
		END IF
	NEXT
	COLOR 15, 1
	PRINT USING " ## "; presenze;
	IF presenze > 0 THEN
		PRINT USING " ###.##"; Voto / presenze;
	ELSE
		PRINT "       ";
	END IF
	PRINT

END SUB

SUB StatGoals ()

DIM Scrn(4000) AS INTEGER
DIM Index AS INTEGER
DIM FirstLine AS INTEGER
DIM OldLine AS INTEGER
DIM in AS STRING
DIM Dummy AS INTEGER

DIM X AS INTEGER, oX AS INTEGER        ' Variabili usate per il mouse
DIM Y AS INTEGER, oY AS INTEGER
DIM Lb AS INTEGER, oLb AS INTEGER
DIM Rb AS INTEGER, oRb AS INTEGER

ScreenSave Scrn()

Win 40, 12, 60, 16, 3, 15, TRUE
Win 40, 12, 56, 12, 3, 15, FALSE

Center 3, " Classifaica GOLEADOR "

LOCATE 20, 17

COLOR 14, 3: PRINT "[CR]";
COLOR 15, 3: PRINT " o ";
COLOR 14, 3: PRINT "[ESC]";
COLOR 15, 3: PRINT " esci              ";
COLOR 14, 3: PRINT "[F12]";
COLOR 15, 3: PRINT " stampa";

REDIM STeam(UBOUND(Squadra)) AS INTEGER

Center 12, " Attendere prego..."
SortPlayer STeam(), 1
Center 12, "                   "
LOCATE 5, 14: PRINT "N";
LOCATE , 19: PRINT "Nome";
LOCATE , 48: PRINT "Ru";
LOCATE , 59: PRINT "Goal"
GOSUB StampaGiocatori

DO
	VscrollBar 68, 12, 12, 3, 15, FirstLine / (UBOUND(Squadra) - 13) * 100

	DO
		in = INKEY$
		oX = X: oY = Y: oLb = Lb: oRb = Rb
		MousePoll Y, X, Lb, Rb
		IF (oX <> X) OR (oY <> Y) THEN  ' Se il mouse si  spostato
			in = CHR$(0)
		END IF
		IF oLb = TRUE AND Lb = FALSE THEN
			IF X = 68 AND (Y >= 6 AND Y <= 18) THEN      'Click sulla barra di scorrimento
				IF Y = 6 THEN                      'Key Up
					in = CHR$(0) + CHR$(72)
				ELSEIF Y = 18 THEN                 'Key Down
					in = CHR$(0) + CHR$(80)
				ELSEIF Y < (FirstLine / (UBOUND(Squadra) - 13) * 13) + 6 THEN  'Page Up
					in = CHR$(0) + CHR$(73)
				ELSEIF Y > (FirstLine / (UBOUND(Squadra) - 13) * 13) + 6 THEN     'Page Down
					in = CHR$(0) + CHR$(81)
				END IF
			ELSE
				in = CHR$(0)
				IF Y = 20 THEN
					IF X > 10 AND X < 40 THEN in = CHR$(13)
					IF X > 40 AND X < 70 THEN in = CHR$(0) + CHR$(134)
				END IF
			END IF
		END IF

	LOOP WHILE in = ""

	OldLine = FirstLine

	SELECT CASE in
		CASE CHR$(0) + CHR$(80)  'Down
			FirstLine = FirstLine + 1
			IF FirstLine > UBOUND(Squadra) - 13 THEN FirstLine = (UBOUND(Squadra) - 13 > 0) * -(UBOUND(Squadra) - 13)
	
		CASE CHR$(0) + CHR$(72)  'Up
			FirstLine = FirstLine - 1
			IF FirstLine < 0 THEN FirstLine = 0

		CASE CHR$(0) + CHR$(73) 'Page Up
			FirstLine = FirstLine - 12
			IF FirstLine < 0 THEN FirstLine = 0
			GOSUB StampaGiocatori
			OldLine = FirstLine

		CASE CHR$(0) + CHR$(81) 'Page Down
			FirstLine = FirstLine + 12
			IF FirstLine > UBOUND(Squadra) - 13 THEN FirstLine = (UBOUND(Squadra) - 13 > 0) * -(UBOUND(Squadra) - 13)
			GOSUB StampaGiocatori
			OldLine = FirstLine
			
		CASE CHR$(13)
			EXIT DO

		CASE CHR$(27)
			EXIT DO

		CASE CHR$(0) + CHR$(59)'[F1]
			Help 40, 12, 60, 15, "fanta.hlp", "CLASSIFICA_GOAL", 4, 15

		CASE CHR$(0) + CHR$(134)    '[F12]
			PStampaGoleador STeam()

			
	END SELECT

	IF OldLine <> FirstLine THEN
		COLOR 14, 3
		ScrollWindow OldLine - FirstLine, 12, 5, 65, 17, 15 + 3 * 16
		Dummy = (OldLine < FirstLine) * -12
		LOCATE 6 + Dummy, 14
		PRINT Squadra(STeam(Dummy + FirstLine + 1)).Numero; "   ";
		PRINT Squadra(STeam(Dummy + FirstLine + 1)).Nome; "         ";
		PRINT Squadra(STeam(Dummy + FirstLine + 1)).Tipo; "       ";
		IF UCASE$(Squadra(STeam(Dummy + FirstLine + 1)).Tipo) = "P" THEN
			COLOR 0, 3
			PRINT CalcolaGoalSubiti(STeam(Dummy + FirstLine + 1)); "  ";
		ELSE
			PRINT "     ";
		END IF
		PRINT CalcolaGoalSegnati(STeam(Dummy + FirstLine + 1));
		COLOR 14, 3
		

	END IF


LOOP

ScreenRestore Scrn()

EXIT SUB

StampaGiocatori:
COLOR 14, 3
LOCATE 6
FOR Index = FirstLine + 1 TO UBOUND(Squadra)
	IF Index - FirstLine > 13 THEN EXIT FOR
	LOCATE , 14
	PRINT Squadra(STeam(Index)).Numero; "   ";
	PRINT Squadra(STeam(Index)).Nome; "         ";
	PRINT Squadra(STeam(Index)).Tipo; "       ";
	IF UCASE$(Squadra(STeam(Index)).Tipo) = "P" THEN
		COLOR 0, 3

		PRINT CalcolaGoalSubiti(STeam(Index)); "  ";

	ELSE
		PRINT "     ";
	END IF


	PRINT CalcolaGoalSegnati(STeam(Index))
	COLOR 14, 3
NEXT
RETURN
END SUB

SUB StatNumeri ()

DIM Scrn(4000) AS INTEGER
DIM Index AS INTEGER
DIM FirstLine AS INTEGER
DIM OldLine AS INTEGER
DIM in AS STRING
DIM Dummy AS INTEGER

DIM Value AS INTEGER
DIM MaxMedia AS INTEGER
DIM MaxPresenze AS INTEGER
DIM MaxMePlayer AS INTEGER
DIM MaxPrPlayer AS INTEGER


ScreenSave Scrn()

Win 40, 13, 65, 18, 3, 15, TRUE

Center 3, " Statistiche in numeri "

LOCATE 22, 17

COLOR 14: PRINT "[CR] ";
COLOR 15: PRINT "o ";
COLOR 14: PRINT "[ESC] ";
COLOR 15: PRINT "esci              ";
COLOR 14: PRINT "[F12] ";
COLOR 15: PRINT "stampa"

LOCATE 8, 15: PRINT "Numero partite vinte:       "; ContaPartite(CP_VINTE)
LOCATE 9, 15: PRINT "Numero partite perse:       "; ContaPartite(CP_PERSE)
LOCATE 10, 15: PRINT "Numero partite pareggiate:  "; ContaPartite(CP_PAREGGIATE)
LOCATE 12, 15: PRINT "Media per partita:        "; CalcolaMediaSq(CM_PARTITA)
LOCATE 13, 15: PRINT "Media inglese:            "; CalcolaMediaSq(CM_INGLESE)
FOR Index = 0 TO UBOUND(Squadra)
	Value = CalcolaMedia(Index)
	IF Value > MaxMedia THEN
		MaxMedia = Value
		MaxMePlayer = Index
	END IF
	Value = CalcolaPresenze(Index)
	IF Value > MaxPresenze THEN
		MaxPresenze = Value
		MaxPrPlayer = Index
	END IF
NEXT

LOCATE 14, 15: PRINT "Giocatore migliore:       "; Squadra(MaxMePlayer).Nome; "("; MaxMedia / 100; ")"
LOCATE 15, 15: PRINT "Giocatore pi presente:   "; Squadra(MaxPrPlayer).Nome; "("; MaxPresenze; ")"

DO
	DO
		in = INKEY$
	LOOP WHILE in = ""

	SELECT CASE in
		CASE CHR$(13)   'Cr
			EXIT DO

		CASE CHR$(27)   'Esc
			EXIT DO

		CASE CHR$(0) + CHR$(134)    '[F12]
			PStampaStatTeam

		CASE CHR$(0) + CHR$(59)     '[F1]
			Help 40, 12, 60, 15, "fanta.hlp", "TEAM_STAT", 4, 15


	END SELECT

LOOP

ScreenRestore Scrn()

END SUB

SUB StatPlayer ()

'Mostra informazioni statistiche sul giocatore selezionato

IF PlyrSel = 0 THEN EXIT SUB    'Esci se nessun giocatore selezionato

DIM Scrn(4000) AS INTEGER
DIM Index AS INTEGER
DIM TIndex AS INTEGER
DIM Voto AS INTEGER
DIM Bonus AS INTEGER
DIM Bonus1 AS INTEGER
DIM Malus AS INTEGER
DIM in AS STRING
DIM Divisione AS INTEGER
DIM Divisione1 AS INTEGER
DIM VArr AS INTEGER
DIM VArr1 AS INTEGER

ScreenSave Scrn()

Win 40, 13, 65, 18, 3, 15, TRUE

LOCATE 5, 17: PRINT " Giocatore: "; Squadra(PlyrSel).Nome
Center 3, "Voti totalizzati per giornata di campionato"

LOCATE 8
FOR Index = 1 TO 11
	LOCATE , 10: PRINT ""
NEXT
LOCATE , 9: PRINT ""; STRING$(61, ""); ""
LOCATE , 11: PRINT " 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0"
PRINT
LOCATE , 20:
COLOR 14: PRINT "[CR] ";
COLOR 15: PRINT "o ";
COLOR 14: PRINT "[ESC] ";
COLOR 15: PRINT "esci        ";
COLOR 14: PRINT "[F12] ";
COLOR 15: PRINT "stampa"
LOCATE 9
LOCATE , 8: PRINT "10"
FOR Index = 9 TO 1 STEP -1
	LOCATE , 9: PRINT RTRIM$(LTRIM$(STR$(Index)))
NEXT


FOR Index = 1 TO 30
	Voto = ASC(MID$(Squadra(PlyrSel).Risultati, Index * 3 - 2, 1)) AND 127

	IF MedieConGoal THEN
		Bonus = ASC(MID$(Squadra(PlyrSel).Risultati, Index * 3 - 1, 1)) AND 127
		Malus = ASC(MID$(Squadra(PlyrSel).Risultati, Index * 3 - 0, 1)) AND 127
		Voto = Voto + Bonus - Malus
		COLOR 14, 3
	ELSE
		COLOR 15, 3
	END IF

	IF Voto THEN
		IF Voto > 120 THEN
			Voto = 115
			LOCATE 7, Index * 2 + 10
			PRINT CHR$(24);
		END IF
		
		LOCATE 9 + (10 - Voto \ 10), Index * 2 + 10
		VArr = CSRLIN
		IF Voto / 10 - Voto \ 10 <> 0 THEN
			PRINT CHR$(220)
			Divisione = TRUE
		ELSE
			PRINT CHR$(32)
			Divisione = FALSE
		END IF

		FOR TIndex = 1 TO Voto \ 10 - 1
			LOCATE , Index * 2 + 10: PRINT CHR$(219)
		NEXT
		
		LOCATE , Index * 2 + 10: PRINT CHR$(223)

		'IF MedieConGoal THEN
		'
		'    IF Bonus THEN
		'        COLOR 14, 3                                     ' Disegno colonnina bonus
		'        Bonus1 = Bonus
		'        IF Voto + Bonus > 110 THEN
		'            Bonus = 110 - Voto
		'            Malus = Malus - (Bonus1 - Bonus)
		'            IF Malus < 0 THEN Malus = 0
		'            LOCATE 7, Index * 2 + 10
		'            PRINT CHR$(24);
		'        END IF
		'
		'        Voto = Voto + Bonus
		'        LOCATE 9 + (10 - Voto \ 10), Index * 2 + 10
		'        VArr1 = CSRLIN
		'        IF Voto / 10 - Voto \ 10 <> 0 THEN
		'            PRINT CHR$(231)
		'            Divisione1 = True
		'        ELSE
		'            PRINT CHR$(32)
		'            Divisione1 = False
		'        END IF
		'
		'        FOR TIndex = 9 + (10 - Voto \ 10) TO VArr - 2 - (Divisione = False)
		'            LOCATE TIndex, Index * 2 + 10: PRINT CHR$(239)
		'        NEXT
		'
		'        IF Divisione THEN
		'            LOCATE , Index * 2 + 10: PRINT CHR$(239)
		'        ELSE
		'            LOCATE , Index * 2 + 10: PRINT CHR$(240)
		'
		'        END IF
		'    ELSE
		'        VArr1 = VArr
		'        Divisione1 = Divisione
		'    END IF
		'
		'
		'    IF Malus THEN
		'        COLOR 4, 3                                     ' Disegno colonnina malus
		'        IF Voto - Malus < 0 THEN
		'            Malus = Voto + 20
		'            LOCATE 7, Index * 2 + 10
		'            PRINT CHR$(24);
		'        END IF
		'
		'        Voto = Voto - Malus
		'        LOCATE VArr1, Index * 2 + 10
		'
		'        IF Divisione1 THEN
		'            PRINT CHR$(231)
		'        ELSE
		'            PRINT CHR$(32)
		'        END IF
		'
		'        FOR TIndex = VArr1 + 1 TO 9 + (10 - Voto \ 10) STEP -1
		'            LOCATE TIndex, Index * 2 + 10: PRINT CHR$(239)
		'        NEXT
		'
		'    END IF
		'
		'END IF
	END IF
	'DO: LOOP WHILE INKEY$ = ""

NEXT

DO
	DO
		in = INKEY$
	LOOP WHILE in = ""

	SELECT CASE in
		CASE CHR$(13)   'Cr
			EXIT DO

		CASE CHR$(27)   'Esc
			EXIT DO

		CASE CHR$(0) + CHR$(134)    '[F12]
			PStampaStatistica

		CASE CHR$(0) + CHR$(59)     '[F1]
			Help 40, 12, 60, 15, "fanta.hlp", "PLAYER_STAT", 4, 15

	END SELECT

LOOP


ScreenRestore Scrn()


END SUB

SUB StatTeam ()

'Informazioni statistiche sulla squadra in totale

DIM Scrn(4000) AS INTEGER
DIM Index AS INTEGER
DIM Risultati AS INTEGER
DIM P_Avv AS INTEGER
DIM P_Squ AS INTEGER
DIM in AS STRING

ScreenSave Scrn()

Win 40, 13, 65, 18, 3, 15, TRUE

Center 3, "Grafico andamento squadra"

LOCATE 8
FOR Index = 1 TO 11
	LOCATE , 10: PRINT ""
NEXT
LOCATE , 9: PRINT ""; STRING$(61, ""); ""
LOCATE , 11: PRINT " 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0"
PRINT
LOCATE , 20:
COLOR 14: PRINT "[CR] ";
COLOR 15: PRINT "o ";
COLOR 14: PRINT "[ESC] ";
COLOR 15: PRINT "esci   ";
COLOR 14: PRINT "[F12] ";
COLOR 15: PRINT "stampa"
LOCATE 13, 9: PRINT "0"
COLOR 14, 3
LOCATE 11, 9: PRINT "+"
COLOR 12, 3
LOCATE 15, 9: PRINT "-"

COLOR 15, 3


FOR Index = 1 TO 30
	IF PartitaGiocata(Index) THEN

		P_Avv = VAL(Campionato(Index).Goal_A)
		P_Squ = VAL(Campionato(Index).Goal_S)

		IF P_Avv = P_Squ THEN
			
		ELSEIF P_Avv < P_Squ THEN
			Risultati = Risultati + 1
		ELSE
			Risultati = Risultati - 1
		END IF


		LOCATE 13 - (Risultati - 1) \ 2, 10 + Index * 2

		IF Risultati <= 11 AND Risultati >= -11 THEN

			IF (Risultati \ 2) * 2 = Risultati THEN
				IF Risultati > 0 THEN
					LOCATE 13 - Risultati \ 2, 10 + Index * 2
				END IF
				PRINT ""
			ELSE
				PRINT ""
			END IF

		ELSE
			IF Risultati > 11 THEN
				LOCATE 8: PRINT ""
			ELSE
				LOCATE 18: PRINT ""
			END IF
		END IF
	END IF

NEXT


DO
	DO
		in = INKEY$
	LOOP WHILE in = ""

	SELECT CASE in
		CASE CHR$(13)   'Cr
			EXIT DO

		CASE CHR$(27)   'Esc
			EXIT DO

		CASE CHR$(0) + CHR$(134)    '[F12]
			PStampaStatTeam

		CASE CHR$(0) + CHR$(59)     '[F1]
			Help 40, 12, 60, 15, "fanta.hlp", "TEAM_STAT", 4, 15


	END SELECT

LOOP

ScreenRestore Scrn()


END SUB

FUNCTION ZTrim$ (in AS STRING)
DIM p AS INTEGER
p = INSTR(in, CHR$(0)) - 1

IF p = -1 THEN
	ZTrim$ = in
ELSE
	ZTrim$ = LEFT$(in, p)
END IF

END FUNCTION

