DECLARE SUB Win (Cx AS INTEGER, Cy AS INTEGER, Wth AS INTEGER, Hht AS INTEGER, WinBackCol AS INTEGER, WinForeCol AS INTEGER, Ombre AS INTEGER)
'$INCLUDE: 'FILE.BI'
'$INCLUDE: 'WIN10.BI'
OPTION EXPLICIT


COMMON SHARED Campionato() AS Giornata
COMMON SHARED Squadra() AS Giocatore

SUB LoadFile (NomeFile AS STRING)

DIM fl AS INTEGER
DIM FileHeader AS Header
DIM Index AS INTEGER
DIM PanchinaCorta AS INTEGER        'FLAG: panchina di 5 giocatori anzich 7 (Versione < 1.02)
DIM GiornataCorta AS INTEGER        'FLAG: assenza dei descrittori aggiuntivi nella struct Giornata (Versione < 1.03)
DIM TrentaGiornate AS INTEGER       'FLAG: trenta giornate di campionato, invece che 40 (Versione < 1.04)
DIM Fine AS INTEGER

IF NomeFile = "" THEN EXIT SUB
IF INSTR(NomeFile, ".") = 0 THEN NomeFile = NomeFile + ".FNT"

fl = FREEFILE

ON LOCAL ERROR RESUME NEXT

'IF NOT (Exists("NomeFile")) THEN
'    Msg 40, 12, "Impossibile aprire il file"
'    EXIT SUB
'END IF

OPEN NomeFile FOR BINARY AS #fl

	GET #fl, , FileHeader

	IF ERR THEN
		Msg 40, 12, "Impossibile aprire il file"
		CLOSE #fl
		EXIT SUB
	END IF


	IF FileHeader.Version > HEADER_VERSION THEN ERROR 32767

	IF FileHeader.Version < HEADER_VERSION THEN
		DIM Low AS INTEGER
		DIM High AS INTEGER

		High = FileHeader.Version AND 255
		Low = FileHeader.Version / 256
		IF SceltaSiNo("Il file selezionato  una vecchia versione; (" + STR$(Low) + "." + STR$(High) + ") convertirlo? ", 40, 12) = 2 THEN
			CLOSE #fl
			EXIT SUB
		ELSE
			IF FileHeader.Version < &H102 THEN PanchinaCorta = True
			IF FileHeader.Version < &H103 THEN GiornataCorta = True
			IF FileHeader.Version < &H104 THEN TrentaGiornate = True
		END IF
	END IF
			  '
	IF TrentaGiornate THEN
		Fine = 30
	ELSE
		Fine = UBOUND(Campionato)
	END IF
			 '
	FOR Index = 1 TO Fine
		GET #fl, , Campionato(Index)
		IF GiornataCorta THEN
			SEEK #fl, SEEK(fl) - 14
			Campionato(Index).DataPartita = "  -  -    "
			Campionato(Index).Puntatore = 0
		END IF

		IF PanchinaCorta THEN
			SEEK #fl, SEEK(fl) - 40 - 5
			GET #fl, , Campionato(Index).TipoFormazione
			Campionato(Index).Formazione(17) = ""
			Campionato(Index).Formazione(18) = ""
		END IF

	NEXT

	IF ERR THEN
		Msg 40, 12, "Errore nel caricamento del file "
		CLOSE #fl
		EXIT SUB
	END IF

	Index = 0
	REDIM Squadra(0) AS Giocatore
	DO
		IF ERR THEN
			EXIT DO
		END IF
		Index = Index + 1
		REDIM PRESERVE Squadra(Index)  AS Giocatore
		IF SEEK(fl) >= LOF(fl) THEN EXIT DO
		GET #fl, , Squadra(Index)
		IF TrentaGiornate THEN
			IF SEEK(fl) >= LOF(fl) THEN
				SEEK #fl, SEEK(fl) - 56
				Index = Index + 1
				REDIM PRESERVE Squadra(Index)  AS Giocatore
				GET #fl, , Squadra(Index)
				EXIT DO
			END IF
			SEEK #fl, SEEK(fl) - 56
		END IF
	LOOP
CLOSE fl
IF Index > 1 THEN
	REDIM PRESERVE Squadra(Index - 1) AS Giocatore
ELSE
	REDIM PRESERVE Squadra(0) AS Giocatore
END IF

IF ERR THEN Msg 40, 12, "Errore nel caricamento del file " + STR$(ERR)


END SUB

SUB SaveFile (NomeFile AS STRING)
DIM fl AS INTEGER
DIM FileHeader AS Header
DIM Index AS INTEGER


IF NomeFile = "" THEN EXIT SUB
IF INSTR(NomeFile, ".") = 0 THEN NomeFile = NomeFile + ".FNT"

fl = FREEFILE

ON LOCAL ERROR RESUME NEXT

IF Exists(NomeFile) THEN                ' Controllo versione del file
	OPEN NomeFile FOR BINARY AS #fl

		GET #fl, , FileHeader

		IF FileHeader.Version <> HEADER_VERSION THEN
			IF SceltaSiNo("Il file selezionato  una versione diversa; salvarlo egualmente? ", 40, 12) = 2 THEN
				CLOSE #fl
				EXIT SUB
			END IF
		END IF
	CLOSE #fl
	KILL NomeFile 'Non si desidera un append!
END IF
   

'IF ERR THEN Msg 40, 12, ERROR$: EXIT SUB
ERR = 0

OPEN NomeFile FOR BINARY ACCESS WRITE AS #fl

	FileHeader.Version = HEADER_VERSION      'Versione file
	FileHeader.FileDesc = FILE_DESC

	PUT #fl, , FileHeader

	FOR Index = 1 TO UBOUND(Campionato)
		PUT #fl, , Campionato(Index)
	NEXT

	FOR Index = 1 TO UBOUND(Squadra)
		PUT #fl, , Squadra(Index)
	NEXT

CLOSE fl

IF ERR THEN Msg 40, 12, "Errore nel salvataggio del file"

END SUB

