DECLARE SUB New (Nome AS STRING, Straniero AS STRING, Numero AS STRING, Tipo AS STRING, Risultati AS STRING)
DECLARE SUB PlayerRestore (Selected AS INTEGER)
DECLARE SUB Menu ()
DECLARE SUB NewTeam ()
DECLARE SUB LoadT ()
DECLARE SUB SalvaT ()
DECLARE SUB LoadFile (NomeFile AS STRING)
DECLARE SUB Salva ()
DECLARE SUB SaveFile (NomeFile AS STRING)
DECLARE SUB ErasePlayer (Player AS INTEGER)
DECLARE SUB ExitProgram ()
DECLARE SUB ModifyPlayer (Selected AS INTEGER)
DECLARE FUNCTION trim (S AS STRING) AS STRING
DECLARE SUB PlayerMask (Selected AS INTEGER)
DECLARE SUB InsertPlayer (Selected AS INTEGER)
DECLARE SUB Mask ()
DECLARE SUB StampaNome (Index AS INTEGER)
DECLARE SUB Scroll (Riga AS INTEGER)
DECLARE SUB Mostra ()

'$INCLUDE: 'WIN10.BI'
'$INCLUDE: 'MOUSE.BI'
'$INCLUDE: 'VBDOS.BI'
'$INCLUDE: 'FILE.BI'

COMMON SHARED Campionato() AS Giornata
COMMON SHARED Squadra() AS Giocatore

OPTION EXPLICIT

CONST CenterX = 40
CONST CenterY = 12

CONST MAX = 3

'CONST False = 0
'CONST True = NOT False

DIM SHARED PosizioneMenu(MAX) AS Pnt

DIM Scrn(4000) AS INTEGER
DIM OldX AS INTEGER
DIM OldY AS INTEGER
DIM Index AS INTEGER
DIM SHARED PlyrSel AS INTEGER
DIM SHARED PlyrRow AS INTEGER

MouseInit
ScreenSave Scrn()
OldX = POS(1)
OldY = CSRLIN


REDIM SHARED Squadra(0)  AS Giocatore
DIM SHARED Campionato(40) AS Giornata


COLOR 15, 1
CLS

IF Exists("Files.dat") THEN
	DIM Fl AS INTEGER
	DIM FileName AS STRING
	Fl = FREEFILE

	OPEN "Files.Dat" FOR INPUT AS #Fl
		INPUT #Fl, FileName
	CLOSE #Fl
	IF Exists(FileName) THEN LoadFile FileName
END IF


Mostra

SUB ErasePlayer (Player AS INTEGER)
IF Player > UBOUND(Squadra) OR Player = 0 THEN EXIT SUB  'Esci se valore assurdo
DIM Index AS INTEGER

FOR Index = Player TO UBOUND(Squadra) - 1
	Squadra(Index) = Squadra(Index + 1)
NEXT

REDIM PRESERVE Squadra(UBOUND(Squadra) - 1) AS Giocatore

END SUB

SUB ExitProgram ()
	IF SceltaSiNo("Si desidera uscire da ambiente definizione squadra? ", 40, 12) = 1 THEN
		COLOR 7, 0
		CLS
		END
	END IF

END SUB

SUB LoadT ()
	DIM NomeFile AS STRING

	InputBox 40, 12, 30, "Carica file", 4, 15, NomeFile
	IF NomeFile = "" THEN EXIT SUB
	LoadFile NomeFile

	Scroll 1
	PlyrSel = 0
	PlyrRow = 1

	DIM Fl AS INTEGER
	ON LOCAL ERROR RESUME NEXT

	Fl = FREEFILE
	OPEN "Files.dat" FOR OUTPUT AS #Fl
		PRINT #Fl, NomeFile
	CLOSE #Fl



END SUB

SUB Mask ()
DIM t AS INTEGER

Win CenterX + 1, CenterY - 1, 76, 18, 1, 7, 0
LOCATE 1, 31
PRINT ""
FOR t = 1 TO 19
	LOCATE , 31: PRINT ""
NEXT
LOCATE , 31
PRINT ""

LOCATE 22, 1:
COLOR 14, 1: PRINT " I";
COLOR 15, 1: PRINT "nserisci",
COLOR 14, 1: PRINT " C";
COLOR 15, 1: PRINT "ancella ",
COLOR 14, 1: PRINT " M";
COLOR 15, 1: PRINT "odifica "

COLOR 14, 1: PRINT " S";
COLOR 15, 1: PRINT "alva    ",
PRINT " C";
COLOR 14, 1: PRINT "a";
COLOR 15, 1: PRINT "rica   ",
COLOR 14, 1: PRINT " N";
COLOR 15, 1: PRINT "uovo    ",
COLOR 14, 1: PRINT " E";
COLOR 15, 1: PRINT "sci     ",

LOCATE 25, 1
COLOR 15, 3: PRINT SPACE$(80);
LOCATE 25, 1
PRINT "[F1] - Help    [ESC] - Menu";
COLOR 15, 1

END SUB

SUB Menu ()

	DIM MenuLine AS INTEGER
	DIM MenuCol  AS INTEGER
	DIM OldMLin AS INTEGER
	DIM OldMCol AS INTEGER
	DIM In AS STRING

	MenuLine = 0
	MenuCol = 0


	LineEvidences MenuCol * 14, MenuLine + 21, 12
	DO
		DO
			In = INKEY$
		LOOP WHILE In = ""

		SELECT CASE In
			CASE CHR$(0) + CHR$(72) 'UP
				MenuLine = MenuLine - 1
				IF MenuLine < 0 THEN MenuLine = 0
				IF MenuLine = 0 THEN
					IF MenuCol > 2 THEN MenuCol = 2
				ELSE
					IF MenuCol > 3 THEN MenuCol = 3
				END IF


			CASE CHR$(0) + CHR$(80) 'DOWN
				MenuLine = MenuLine + 1
				IF MenuLine > 1 THEN MenuLine = 1

			CASE CHR$(0) + CHR$(75) 'LEFT
				MenuCol = MenuCol - 1
				IF MenuCol < 0 THEN MenuCol = 0

			CASE CHR$(0) + CHR$(77) 'RIGHT
				MenuCol = MenuCol + 1
				IF MenuLine = 0 THEN
					IF MenuCol > 2 THEN MenuCol = 2
				ELSE
					IF MenuCol > 3 THEN MenuCol = 3
				END IF

			CASE CHR$(0) + CHR$(59)'F1
				Help CenterX, CenterY, 60, 15, "FANTA.HLP", "NEW_MENU", 4, 15
				
			CASE CHR$(27)
				EXIT DO

			CASE CHR$(13)
				IF MenuLine = 0 AND MenuCol = 0 THEN
					New STRING$(3, "-"), "N", "0", "-", STRING$(100, CHR$(0))
					Scroll PlyrRow
					EXIT DO
				END IF

				IF MenuLine = 0 AND MenuCol = 1 THEN
					ErasePlayer PlyrSel
					Scroll PlyrRow
					IF CSRLIN < 21 THEN
						LOCATE , 3: PRINT SPACE$(28);
						LOCATE , 32: PRINT SPACE$(40);
					END IF
					IF PlyrSel = UBOUND(Squadra) + 1 THEN PlyrSel = UBOUND(Squadra)  'Evita che vi sia una selezione non valida

					EXIT DO
				END IF

				IF MenuLine = 0 AND MenuCol = 2 THEN ModifyPlayer PlyrSel: EXIT DO
				IF MenuLine = 1 AND MenuCol = 0 THEN SalvaT: EXIT DO
				IF MenuLine = 1 AND MenuCol = 1 THEN
					LoadT
					EXIT DO
				END IF

				IF MenuLine = 1 AND MenuCol = 2 THEN
					NewTeam
					PlyrSel = 0
					PlyrRow = 1
					EXIT DO
				END IF

				IF MenuLine = 1 AND MenuCol = 3 THEN ExitProgram: EXIT DO
				COLOR 15, 1

		END SELECT

		IF OldMLin <> MenuLine OR OldMCol <> MenuCol THEN
			LineEvidences OldMCol * 14, OldMLin + 21, 12
			OldMLin = MenuLine
			OldMCol = MenuCol
			LineEvidences MenuCol * 14, MenuLine + 21, 12
		END IF

	LOOP
	LineEvidences MenuCol * 14, MenuLine + 21, 12

END SUB

SUB ModifyPlayer (Selected AS INTEGER)
	DIM Scrn(4000) AS INTEGER
	DIM In AS STRING
	DIM Posiz AS INTEGER
	DIM ActualContent AS STRING
	DIM Format AS STRING
	
	ScreenSave Scrn()
	IF Selected = 0 THEN EXIT SUB

	PlayerMask Selected
	
	COLOR 15, 3
	Center 5, "Giocatore"

	DO
		LOCATE PosizioneMenu(Posiz).Y, PosizioneMenu(Posiz).X
		COLOR PosizioneMenu(Posiz).C, 7

		ActualContent = PosizioneMenu(Posiz).t
		
		In = MaskedInput(True, PosizioneMenu(Posiz).D, ActualContent, True)

		IF Posiz = 3 THEN
			ActualContent = UCASE$(ActualContent)
			IF ActualContent <> "S" AND ActualContent <> "N" THEN
				ActualContent = LEFT$(PosizioneMenu(Posiz).t, 1)        'Un sistema non troppo buono...
			END IF                                                      'Il contenuto qui  di una sola lettera.
		END IF
		
		LOCATE PosizioneMenu(Posiz).Y, PosizioneMenu(Posiz).X
		COLOR PosizioneMenu(Posiz).C, 0
		PRINT SPACE$(PosizioneMenu(Posiz).D);

		LOCATE PosizioneMenu(Posiz).Y, PosizioneMenu(Posiz).X
		PRINT ActualContent;
		
		PosizioneMenu(Posiz).t = ActualContent

		
		SELECT CASE In
			CASE CHR$(9)            'Tab
				Posiz = Posiz + 1

			CASE CHR$(0) + CHR$(15) 'Shift + Tab
				Posiz = Posiz - 1

			CASE CHR$(27)           'ESC
				EXIT DO

			CASE CHR$(13)           'CR
				PlayerRestore (Selected)
				EXIT DO

			CASE CHR$(0) + CHR$(59)  'F1
				Help CenterX, CenterY, 60, 15, "FANTA.HLP", "MODIFY_PLAYER", 4, 15

		END SELECT

		IF Posiz < 0 THEN Posiz = 0
		IF Posiz > MAX THEN Posiz = MAX

	LOOP

	ScreenRestore Scrn()

END SUB

SUB Mostra ()

DIM Index AS INTEGER
DIM In AS STRING
DIM OldSelect AS INTEGER

Mask

PlyrRow = 1
IF UBOUND(Squadra) THEN
	PlyrSel = PlyrRow
ELSE
	PlyrSel = 0
END IF

Scroll PlyrRow

IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 75
' MouseShow
DO
	OldSelect = PlyrSel
	DO
		In = INKEY$
	LOOP WHILE In = ""

	
	SELECT CASE In
		CASE CHR$(0) + CHR$(72) 'Su
			PlyrSel = PlyrSel - 1

		CASE CHR$(0) + CHR$(80) 'Gi
			PlyrSel = PlyrSel + 1

		CASE CHR$(27) 'ESC
			IF PlyrSel THEN
				LineEvidences 2, PlyrSel - PlyrRow + 1, 75
				LOCATE PlyrSel - PlyrRow + 2, 3: PRINT CHR$(16)
			END IF

			OldSelect = PlyrSel
			Menu
			
			IF PlyrSel THEN
				COLOR 15, 1
				LOCATE PlyrSel - PlyrRow + 2, 3
				StampaNome PlyrSel
				LineEvidences 2, PlyrSel - PlyrRow + 1, 75
			END IF
			IF OldSelect THEN LOCATE OldSelect - PlyrRow + 2, 3: PRINT " "
			OldSelect = PlyrSel


		CASE CHR$(0) + CHR$(59)'F1
			Help CenterX, CenterY, 60, 15, "FANTA.HLP", "SHOW_TEAM", 4, 15

		CASE CHR$(0) + CHR$(18) 'Alt E
			ExitProgram

		CASE CHR$(0) + CHR$(23) 'Alt I
			IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 75

			New STRING$(3, "-"), "N", "0", "-", STRING$(100, CHR$(0))
			Scroll PlyrRow
			
			IF PlyrSel THEN
				COLOR 15, 1
				LOCATE PlyrSel - PlyrRow + 2, 3
				StampaNome PlyrSel
				LineEvidences 2, PlyrSel - PlyrRow + 1, 75
			END IF

		CASE CHR$(0) + CHR$(46) 'Alt C
			IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 75
			ErasePlayer PlyrSel

			IF PlyrSel = UBOUND(Squadra) + 1 THEN PlyrSel = UBOUND(Squadra)  'Evita che vi sia una selezione non valida
			Scroll PlyrRow
			IF CSRLIN < 21 THEN
				LOCATE , 3: PRINT SPACE$(28);
				LOCATE , 32: PRINT SPACE$(40);
			END IF

			IF PlyrSel THEN
				COLOR 15, 1
				LOCATE PlyrSel - PlyrRow + 2, 3
				StampaNome PlyrSel
				LineEvidences 2, PlyrSel - PlyrRow + 1, 75
			END IF
			OldSelect = PlyrSel


		CASE CHR$(0) + CHR$(50) 'Alt M
			IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 75

			ModifyPlayer PlyrSel

			IF PlyrSel THEN
				COLOR 15, 1
				LOCATE PlyrSel - PlyrRow + 2, 3
				StampaNome PlyrSel
				LineEvidences 2, PlyrSel - PlyrRow + 1, 75
			END IF


		CASE CHR$(0) + CHR$(30)  'Alt A
			IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 75
			LoadT
			Scroll PlyrRow
			OldSelect = 0
			
		CASE CHR$(0) + CHR$(31)  'Alt S
			SalvaT

		CASE CHR$(0) + CHR$(49)  'Alt N
			NewTeam



	END SELECT

	
	IF PlyrSel > UBOUND(Squadra) THEN PlyrSel = UBOUND(Squadra)
	IF UBOUND(Squadra) = 0 THEN
		PlyrSel = 0
	ELSE
		IF PlyrSel < 1 THEN PlyrSel = 1
	END IF

	COLOR 15, 1

	IF PlyrSel > PlyrRow + 18 THEN
		LineEvidences 2, OldSelect - PlyrRow + 1, 75
		PlyrRow = PlyrRow + 1

		ScrollWindow -1, 3, 1, 75, 19, 1 * 16 + 7
		LOCATE 20: StampaNome PlyrRow + 18

		OldSelect = PlyrSel
		LineEvidences 2, PlyrSel - PlyrRow + 1, 75
	END IF


	IF PlyrSel < PlyrRow AND PlyrSel <> 0 THEN
		IF OldSelect THEN LineEvidences 2, OldSelect - PlyrRow + 1, 75
		PlyrRow = PlyrRow - 1

		ScrollWindow 1, 3, 1, 75, 19, 1 * 16 + 7
		LOCATE 2: StampaNome PlyrRow

		OldSelect = PlyrSel
		LineEvidences 2, PlyrSel - PlyrRow + 1, 75
	END IF


	IF OldSelect <> PlyrSel THEN
		IF OldSelect THEN LineEvidences 2, OldSelect - PlyrRow + 1, 75
		IF PlyrSel THEN LineEvidences 2, PlyrSel - PlyrRow + 1, 75
	END IF

	
LOOP



END SUB

SUB New (Nome AS STRING, Straniero AS STRING, Numero AS STRING, Tipo AS STRING, Risultati AS STRING)

REDIM PRESERVE Squadra(UBOUND(Squadra) + 1) AS Giocatore

Squadra(UBOUND(Squadra)).Nome = Nome
Squadra(UBOUND(Squadra)).Straniero = Straniero
Squadra(UBOUND(Squadra)).Numero = Numero
Squadra(UBOUND(Squadra)).Tipo = Tipo
Squadra(UBOUND(Squadra)).Risultati = Risultati


END SUB

SUB NewTeam ()
	IF SceltaSiNo("Si desidera creare una nuova squadra? ", 40, 12) = 1 THEN
		REDIM Squadra(0) AS Giocatore
		REDIM Campionato(30) AS Giornata
		Scroll 1
		ScrollWindow 20, 32, 1, 76, 19, 15 + 16
		PlyrSel = 0
		PlyrRow = 1
	END IF

END SUB

SUB PlayerMask (Selected AS INTEGER)

	' Tutta 'sta pappardella  la maschera di inserimento dati
	' per ciascun giocatore.

	DIM Index AS INTEGER

	Win CenterX, CenterY, 50, 12, 3, 15, 1

	COLOR 14, 3
	LOCATE 18, CenterX - 14: PRINT " [CR]";
	COLOR 15, 3: PRINT " OK     "; : COLOR 14, 3: PRINT "[ESC]";
	COLOR 15, 3: PRINT " Annulla "
	
	LOCATE CenterY - 5, CenterX - 20: PRINT "     Nome:";
	COLOR 15, 0
	PosizioneMenu(0).X = POS(1)
	PosizioneMenu(0).Y = CSRLIN
	PosizioneMenu(0).C = 15
	PosizioneMenu(0).D = LEN(Squadra(Selected).Nome)
	PosizioneMenu(0).t = Squadra(Selected).Nome
	PRINT Squadra(Selected).Nome
	PRINT

	COLOR 15, 3
	LOCATE , CenterX - 20: PRINT "    Ruolo:";
	COLOR 15, 0
	PosizioneMenu(1).X = POS(1)
	PosizioneMenu(1).Y = CSRLIN
	PosizioneMenu(1).C = 15
	PosizioneMenu(1).D = LEN(Squadra(Selected).Tipo)
	PosizioneMenu(1).t = Squadra(Selected).Tipo
	PRINT Squadra(Selected).Tipo
	PRINT

	COLOR 15, 3
	LOCATE , CenterX - 20: PRINT "   Numero:";
	COLOR 15, 0
	PosizioneMenu(2).X = POS(1)
	PosizioneMenu(2).Y = CSRLIN
	PosizioneMenu(2).C = 15
	PosizioneMenu(2).D = LEN(Squadra(Selected).Numero)
	PosizioneMenu(2).t = Squadra(Selected).Numero
	PRINT Squadra(Selected).Numero
	PRINT

	COLOR 15, 3
	LOCATE , CenterX - 20: PRINT "Straniero:";
	COLOR 15, 0
	PosizioneMenu(3).X = POS(1)
	PosizioneMenu(3).Y = CSRLIN
	PosizioneMenu(3).C = 15
	PosizioneMenu(3).D = LEN(Squadra(Selected).Straniero)
	PosizioneMenu(3).t = Squadra(Selected).Straniero
	PRINT Squadra(Selected).Straniero

END SUB

SUB PlayerRestore (Selected AS INTEGER)
	DIM Index AS INTEGER
	
	Squadra(Selected).Nome = PosizioneMenu(0).t
	Squadra(Selected).Tipo = PosizioneMenu(1).t
	Squadra(Selected).Numero = PosizioneMenu(2).t
	Squadra(Selected).Straniero = PosizioneMenu(3).t

END SUB

SUB SalvaT ()
	DIM NomeFile AS STRING
	ON LOCAL ERROR RESUME NEXT

	InputBox 40, 12, 30, "Salva su file", 4, 15, NomeFile
	IF NomeFile = "" THEN EXIT SUB
	SaveFile NomeFile

	DIM Fl AS INTEGER
	ON LOCAL ERROR RESUME NEXT

	Fl = FREEFILE
	OPEN "Files.dat" FOR OUTPUT AS #Fl
		PRINT #Fl, NomeFile
	CLOSE #Fl
	
END SUB

SUB Scroll (Riga AS INTEGER)
DIM Index AS INTEGER
DIM k AS INTEGER

LOCATE 2
COLOR 15, 1
MouseHide

ScrollWindow 20, 2, 1, 29, 19, 16 + 15  'Cancella la finestra
ScrollWindow 20, 31, 1, 77, 19, 16 + 15

FOR Index = Riga TO Riga + 18
	IF Index > UBOUND(Squadra) THEN EXIT FOR
	StampaNome Index
	PRINT

NEXT
MouseShow

END SUB

SUB StampaNome (Index AS INTEGER)
	DIM k AS INTEGER
	DIM Voto AS INTEGER

	LOCATE , 5
	COLOR 15, 1
	PRINT Squadra(Index).Numero; " ";

	IF Squadra(Index).Straniero = "S" THEN COLOR 14, 1
	PRINT Squadra(Index).Nome; " ";
	COLOR 15, 1
	PRINT Squadra(Index).Tipo;
	COLOR 7, 1
	LOCATE , 31: PRINT " ";
	COLOR 15, 1

	FOR k = 1 TO 30
		
		Voto = ASC(MID$(Squadra(Index).Risultati, k * 3 - 2, 1))


		IF Voto AND 128 THEN
			COLOR 12, 1
			PRINT "*";
		ELSEIF Voto THEN
			COLOR 15, 1
			PRINT "+";
		ELSE
			PRINT " ";
		END IF
	NEXT
	COLOR 15, 1
	
END SUB

